/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoMetaDataFactory;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

public class DaoMetaDataFactoryImpl
implements DaoMetaDataFactory,
Disposable {
    protected Map daoMetaDataCache = new HashMap();
    protected DataSource dataSource;
    protected StatementFactory statementFactory;
    protected ResultSetFactory resultSetFactory;
    protected AnnotationReaderFactory annotationReaderFactory;
    protected ValueTypeFactory valueTypeFactory;
    protected String sqlFileEncoding;
    protected String[] daoSuffixes;
    protected String[] insertPrefixes;
    protected String[] deletePrefixes;
    protected String[] updatePrefixes;
    protected String[] unlessNullSuffixes;
    protected boolean initialized;

    public DaoMetaDataFactoryImpl(DataSource dataSource, StatementFactory statementFactory, ResultSetFactory resultSetFactory, AnnotationReaderFactory readerFactory) {
        this.dataSource = dataSource;
        this.statementFactory = statementFactory;
        this.resultSetFactory = resultSetFactory;
        this.annotationReaderFactory = readerFactory;
    }

    public void setSqlFileEncoding(String encoding) {
        this.sqlFileEncoding = encoding;
    }

    public void setDaoSuffixes(String[] suffixes) {
        this.daoSuffixes = suffixes;
    }

    public void setInsertPrefixes(String[] prefixes) {
        this.insertPrefixes = prefixes;
    }

    public void setDeletePrefixes(String[] prefixes) {
        this.deletePrefixes = prefixes;
    }

    public void setUpdatePrefixes(String[] prefixes) {
        this.updatePrefixes = prefixes;
    }

    public void setUnlessNullSuffixes(String[] suffixes) {
        this.unlessNullSuffixes = suffixes;
    }

    public synchronized DaoMetaData getDaoMetaData(Class daoClass) {
        String key;
        DaoMetaData dmd;
        if (!this.initialized) {
            DisposableUtil.add((Disposable)this);
            this.initialized = true;
        }
        if ((dmd = (DaoMetaData)this.daoMetaDataCache.get(key = daoClass.getName())) != null) {
            return dmd;
        }
        DaoMetaData dmdi = this.createDaoMetaData(daoClass);
        this.daoMetaDataCache.put(key, dmdi);
        return dmdi;
    }

    protected DaoMetaData createDaoMetaData(Class daoClass) {
        DaoMetaDataImpl daoMetaData = new DaoMetaDataImpl();
        daoMetaData.setDaoClass(daoClass);
        daoMetaData.setDataSource(this.dataSource);
        daoMetaData.setStatementFactory(this.statementFactory);
        daoMetaData.setResultSetFactory(this.resultSetFactory);
        daoMetaData.setAnnotationReaderFactory(this.annotationReaderFactory);
        daoMetaData.setValueTypeFactory(this.valueTypeFactory);
        if (this.sqlFileEncoding != null) {
            daoMetaData.setSqlFileEncoding(this.sqlFileEncoding);
        }
        if (this.daoSuffixes != null) {
            daoMetaData.setDaoSuffixes(this.daoSuffixes);
        }
        if (this.insertPrefixes != null) {
            daoMetaData.setInsertPrefixes(this.insertPrefixes);
        }
        if (this.updatePrefixes != null) {
            daoMetaData.setUpdatePrefixes(this.updatePrefixes);
        }
        if (this.deletePrefixes != null) {
            daoMetaData.setDeletePrefixes(this.deletePrefixes);
        }
        if (this.unlessNullSuffixes != null) {
            daoMetaData.setUnlessNullSuffixes(this.unlessNullSuffixes);
        }
        daoMetaData.initialize();
        return daoMetaData;
    }

    public void setValueTypeFactory(ValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }

    public synchronized void dispose() {
        this.daoMetaDataCache.clear();
        this.initialized = false;
    }
}

