/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.IdentifierGenerator;
import org.seasar.dao.NotSingleRowUpdatedRuntimeException;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.InsertAutoHandler;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.framework.exception.SRuntimeException;

public class InsertAutoDynamicCommand
implements SqlCommand {
    private DataSource dataSource;
    private StatementFactory statementFactory;
    private BeanMetaData beanMetaData;
    private String[] propertyNames;
    private Class notSingleRowUpdatedExceptionClass;

    public Object execute(Object[] args) {
        Object bean = args[0];
        BeanMetaData bmd = this.getBeanMetaData();
        PropertyType[] propertyTypes = this.createInsertPropertyTypes(bmd, bean, this.getPropertyNames());
        String sql = this.createInsertSql(bmd, propertyTypes);
        InsertAutoHandler handler = new InsertAutoHandler(this.getDataSource(), this.getStatementFactory(), bmd, propertyTypes);
        handler.setSql(sql);
        int rows = handler.execute(args);
        if (rows != 1) {
            throw new NotSingleRowUpdatedRuntimeException(args[0], rows);
        }
        return new Integer(rows);
    }

    protected String createInsertSql(BeanMetaData bmd, PropertyType[] propertyTypes) {
        int i;
        StringBuffer buf = new StringBuffer(100);
        buf.append("INSERT INTO ");
        buf.append(bmd.getTableName());
        buf.append(" (");
        for (i = 0; i < propertyTypes.length; ++i) {
            PropertyType pt = propertyTypes[i];
            String columnName = pt.getColumnName();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(columnName);
        }
        buf.append(") VALUES (");
        for (i = 0; i < propertyTypes.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append("?");
        }
        buf.append(")");
        return buf.toString();
    }

    protected PropertyType[] createInsertPropertyTypes(BeanMetaData bmd, Object bean, String[] propertyNames) {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        IdentifierGenerator identifierGenerator = bmd.getIdentifierGenerator();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName;
            PropertyType pt = bmd.getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey() ? !identifierGenerator.isSelfGenerate() : pt.getPropertyDesc().getValue(bean) == null && !(propertyName = pt.getPropertyName()).equalsIgnoreCase(timestampPropertyName) && !propertyName.equalsIgnoreCase(versionNoPropertyName)) continue;
            types.add(pt);
        }
        if (types.isEmpty()) {
            throw new SRuntimeException("EDAO0014");
        }
        PropertyType[] propertyTypes = types.toArray(new PropertyType[types.size()]);
        return propertyTypes;
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected Class getNotSingleRowUpdatedExceptionClass() {
        return this.notSingleRowUpdatedExceptionClass;
    }

    public void setNotSingleRowUpdatedExceptionClass(Class notSingleRowUpdatedExceptionClass) {
        this.notSingleRowUpdatedExceptionClass = notSingleRowUpdatedExceptionClass;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    protected BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public void setBeanMetaData(BeanMetaData beanMetaData) {
        this.beanMetaData = beanMetaData;
    }

    protected String[] getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }
}

