/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.parser;

import java.util.Stack;
import org.seasar.dao.EndCommentNotFoundRuntimeException;
import org.seasar.dao.IfConditionNotFoundRuntimeException;
import org.seasar.dao.Node;
import org.seasar.dao.SqlParser;
import org.seasar.dao.SqlTokenizer;
import org.seasar.dao.node.BeginNode;
import org.seasar.dao.node.BindVariableNode;
import org.seasar.dao.node.ContainerNode;
import org.seasar.dao.node.ElseNode;
import org.seasar.dao.node.EmbeddedValueNode;
import org.seasar.dao.node.IfNode;
import org.seasar.dao.node.ParenBindVariableNode;
import org.seasar.dao.node.PrefixSqlNode;
import org.seasar.dao.node.SqlNode;
import org.seasar.dao.parser.SqlTokenizerImpl;
import org.seasar.framework.util.StringUtil;

public class SqlParserImpl
implements SqlParser {
    private SqlTokenizer tokenizer;
    private Stack nodeStack = new Stack();

    public SqlParserImpl(String sql) {
        sql = sql.trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        this.tokenizer = new SqlTokenizerImpl(sql);
    }

    public Node parse() {
        this.push(new ContainerNode());
        while (99 != this.tokenizer.next()) {
            this.parseToken();
        }
        return this.pop();
    }

    protected void parseToken() {
        switch (this.tokenizer.getTokenType()) {
            case 1: {
                this.parseSql();
                break;
            }
            case 2: {
                this.parseComment();
                break;
            }
            case 3: {
                this.parseElse();
                break;
            }
            case 4: {
                this.parseBindVariable();
            }
        }
    }

    protected void parseSql() {
        Node node;
        String sql = this.tokenizer.getToken();
        if (this.isElseMode()) {
            sql = StringUtil.replace((String)sql, (String)"--", (String)"");
        }
        if (((node = this.peek()) instanceof IfNode || node instanceof ElseNode) && node.getChildSize() == 0) {
            SqlTokenizerImpl st = new SqlTokenizerImpl(sql);
            st.skipWhitespace();
            String token = st.skipToken();
            st.skipWhitespace();
            if (sql.startsWith(",")) {
                if (sql.startsWith(", ")) {
                    node.addChild(new PrefixSqlNode(", ", sql.substring(2)));
                } else {
                    node.addChild(new PrefixSqlNode(",", sql.substring(1)));
                }
            } else if ("AND".equalsIgnoreCase(token) || "OR".equalsIgnoreCase(token)) {
                node.addChild(new PrefixSqlNode(st.getBefore(), st.getAfter()));
            } else {
                node.addChild(new SqlNode(sql));
            }
        } else {
            node.addChild(new SqlNode(sql));
        }
    }

    protected void parseComment() {
        String comment = this.tokenizer.getToken();
        if (SqlParserImpl.isTargetComment(comment)) {
            if (SqlParserImpl.isIfComment(comment)) {
                this.parseIf();
            } else if (SqlParserImpl.isBeginComment(comment)) {
                this.parseBegin();
            } else {
                if (SqlParserImpl.isEndComment(comment)) {
                    return;
                }
                this.parseCommentBindVariable();
            }
        } else if (comment != null && 0 < comment.length()) {
            String before = this.tokenizer.getBefore();
            this.peek().addChild(new SqlNode(before.substring(before.lastIndexOf("/*"))));
        }
    }

    protected void parseIf() {
        String condition = this.tokenizer.getToken().substring(2).trim();
        if (StringUtil.isEmpty((String)condition)) {
            throw new IfConditionNotFoundRuntimeException();
        }
        IfNode ifNode = new IfNode(condition);
        this.peek().addChild(ifNode);
        this.push(ifNode);
        this.parseEnd();
    }

    protected void parseBegin() {
        BeginNode beginNode = new BeginNode();
        this.peek().addChild(beginNode);
        this.push(beginNode);
        this.parseEnd();
    }

    protected void parseEnd() {
        while (99 != this.tokenizer.next()) {
            if (this.tokenizer.getTokenType() == 2 && SqlParserImpl.isEndComment(this.tokenizer.getToken())) {
                this.pop();
                return;
            }
            this.parseToken();
        }
        throw new EndCommentNotFoundRuntimeException();
    }

    protected void parseElse() {
        Node parent = this.peek();
        if (!(parent instanceof IfNode)) {
            return;
        }
        IfNode ifNode = (IfNode)this.pop();
        ElseNode elseNode = new ElseNode();
        ifNode.setElseNode(elseNode);
        this.push(elseNode);
        this.tokenizer.skipWhitespace();
    }

    protected void parseCommentBindVariable() {
        String expr = this.tokenizer.getToken();
        String s = this.tokenizer.skipToken();
        if (s.startsWith("(") && s.endsWith(")")) {
            this.peek().addChild(new ParenBindVariableNode(expr));
        } else if (expr.startsWith("$")) {
            this.peek().addChild(new EmbeddedValueNode(expr.substring(1)));
        } else {
            this.peek().addChild(new BindVariableNode(expr));
        }
    }

    protected void parseBindVariable() {
        String expr = this.tokenizer.getToken();
        this.peek().addChild(new BindVariableNode(expr));
    }

    protected Node pop() {
        return (Node)this.nodeStack.pop();
    }

    protected Node peek() {
        return (Node)this.nodeStack.peek();
    }

    protected void push(Node node) {
        this.nodeStack.push(node);
    }

    protected boolean isElseMode() {
        for (int i = 0; i < this.nodeStack.size(); ++i) {
            if (!(this.nodeStack.get(i) instanceof ElseNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTargetComment(String comment) {
        return comment != null && comment.length() > 0 && Character.isJavaIdentifierStart(comment.charAt(0));
    }

    private static boolean isIfComment(String comment) {
        return comment.startsWith("IF");
    }

    private static boolean isBeginComment(String content) {
        return content != null && "BEGIN".equals(content);
    }

    private static boolean isEndComment(String content) {
        return content != null && "END".equals(content);
    }
}

