/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.S2ContainerImpl;

public final class S2ContainerBehavior {
    private static Provider provider = new DefaultProvider();

    private S2ContainerBehavior() {
    }

    public static Provider getProvider() {
        return provider;
    }

    public static void setProvider(Provider p) {
        provider = p;
    }

    public static ComponentDef acquireFromGetComponent(S2Container container, Object key) {
        return S2ContainerBehavior.getProvider().acquireFromGetComponent(container, key);
    }

    public static ComponentDef acquireFromGetComponentDef(S2Container container, Object key) {
        return S2ContainerBehavior.getProvider().acquireFromGetComponentDef(container, key);
    }

    public static ComponentDef acquireFromGetComponentDef(S2Container container, int index) {
        return S2ContainerBehavior.getProvider().acquireFromGetComponentDef(container, index);
    }

    public static ComponentDef acquireFromHasComponentDef(S2Container container, Object key) {
        return S2ContainerBehavior.getProvider().acquireFromHasComponentDef(container, key);
    }

    public static ComponentDef acquireFromInjectDependency(S2Container container, Object key) {
        return S2ContainerBehavior.getProvider().acquireFromInjectDependency(container, key);
    }

    public static int acquireFromGetComponentDefSize(S2Container container) {
        return S2ContainerBehavior.getProvider().acquireFromGetComponentDefSize(container);
    }

    public static void acquireFromRegister(S2Container container, ComponentDef cd) {
        S2ContainerBehavior.getProvider().acquireFromRegister(container, cd);
    }

    public static class SynchronizedProvider
    extends DefaultProvider {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ComponentDef getComponentDef(S2Container container, int index) {
            S2Container s2Container = container;
            synchronized (s2Container) {
                return super.getComponentDef(container, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ComponentDef getComponentDef(S2Container container, Object key) {
            S2Container s2Container = container;
            synchronized (s2Container) {
                return super.getComponentDef(container, key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int getComponentDefSize(S2Container container) {
            S2Container s2Container = container;
            synchronized (s2Container) {
                return super.getComponentDefSize(container);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(S2Container container, ComponentDef cd) {
            S2Container s2Container = container;
            synchronized (s2Container) {
                super.register(container, cd);
            }
        }
    }

    public static class DefaultProvider
    implements Provider {
        public ComponentDef acquireFromGetComponent(S2Container container, Object key) {
            return this.acquireFromGetComponentDef(container, key);
        }

        public ComponentDef acquireFromGetComponentDef(S2Container container, Object key) {
            ComponentDef cd = this.getComponentDef(container, key);
            if (cd == null) {
                throw new ComponentNotFoundRuntimeException(key);
            }
            return cd;
        }

        public ComponentDef acquireFromGetComponentDef(S2Container container, int index) {
            return this.getComponentDef(container, index);
        }

        public ComponentDef acquireFromHasComponentDef(S2Container container, Object key) {
            return this.getComponentDef(container, key);
        }

        public ComponentDef acquireFromInjectDependency(S2Container container, Object key) {
            return this.acquireFromGetComponentDef(container, key);
        }

        public int acquireFromGetComponentDefSize(S2Container container) {
            return this.getComponentDefSize(container);
        }

        public void acquireFromRegister(S2Container container, ComponentDef cd) {
            this.register(container, cd);
        }

        protected ComponentDef getComponentDef(S2Container container, Object key) {
            return ((S2ContainerImpl)container).internalGetComponentDef(key);
        }

        protected ComponentDef getComponentDef(S2Container container, int index) {
            return ((S2ContainerImpl)container).internalGetComponentDef(index);
        }

        protected int getComponentDefSize(S2Container container) {
            return ((S2ContainerImpl)container).internalGetComponentDefSize();
        }

        protected void register(S2Container container, ComponentDef cd) {
            ((S2ContainerImpl)container).internalRegister(cd);
        }
    }

    public static interface Provider {
        public ComponentDef acquireFromGetComponent(S2Container var1, Object var2);

        public ComponentDef acquireFromGetComponentDef(S2Container var1, Object var2);

        public ComponentDef acquireFromGetComponentDef(S2Container var1, int var2);

        public ComponentDef acquireFromHasComponentDef(S2Container var1, Object var2);

        public ComponentDef acquireFromInjectDependency(S2Container var1, Object var2);

        public int acquireFromGetComponentDefSize(S2Container var1);

        public void acquireFromRegister(S2Container var1, ComponentDef var2);
    }
}

