/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dao.pager.PagerCondition;

public class PagerUtil {
    public static boolean isPrev(PagerCondition condition) {
        boolean prev = condition.getOffset() > 0;
        return prev;
    }

    public static boolean isNext(PagerCondition condition) {
        boolean next = condition.getCount() > 0 && condition.getOffset() + condition.getLimit() < condition.getCount();
        return next;
    }

    public static int getCurrentLastOffset(PagerCondition condition) {
        int nextOffset = PagerUtil.getNextOffset(condition);
        if (nextOffset <= 0 || condition.getCount() <= 0) {
            return 0;
        }
        return nextOffset < condition.getCount() ? nextOffset - 1 : condition.getCount() - 1;
    }

    public static int getNextOffset(PagerCondition condition) {
        return condition.getOffset() + condition.getLimit();
    }

    public static int getPrevOffset(PagerCondition condition) {
        int prevOffset = condition.getOffset() - condition.getLimit();
        return prevOffset < 0 ? 0 : prevOffset;
    }

    public static int getPageIndex(PagerCondition condition) {
        if (condition.getLimit() == 0) {
            return 1;
        }
        return condition.getOffset() / condition.getLimit();
    }

    public static int getPageCount(PagerCondition condition) {
        return PagerUtil.getPageIndex(condition) + 1;
    }

    public static int getLastPageIndex(PagerCondition condition) {
        if (condition.getLimit() == 0) {
            return 0;
        }
        return (condition.getCount() - 1) / condition.getLimit();
    }

    public static int getDisplayPageIndexBegin(PagerCondition condition, int displayPageMax) {
        int lastPageIndex = PagerUtil.getLastPageIndex(condition);
        if (lastPageIndex < displayPageMax) {
            return 0;
        }
        int currentPageIndex = PagerUtil.getPageIndex(condition);
        int displayPageIndexBegin = currentPageIndex - (int)Math.floor(displayPageMax / 2);
        return displayPageIndexBegin < 0 ? 0 : displayPageIndexBegin;
    }

    public static int getDisplayPageIndexEnd(PagerCondition condition, int displayPageMax) {
        int displayPageIndexBegin;
        int lastPageIndex = PagerUtil.getLastPageIndex(condition);
        int displayPageRange = lastPageIndex - (displayPageIndexBegin = PagerUtil.getDisplayPageIndexBegin(condition, displayPageMax));
        if (displayPageRange < displayPageMax) {
            return lastPageIndex;
        }
        return displayPageIndexBegin + displayPageMax - 1;
    }

    public static List filter(List list, PagerCondition condition) {
        condition.setCount(list.size());
        if (condition.getLimit() == -1) {
            return list;
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            if (i < condition.getOffset() || i >= condition.getOffset() + condition.getLimit()) continue;
            result.add(list.get(i));
        }
        return result;
    }
}

