/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.emulator;

import java.io.Serializable;

public interface PlcMemory {
    public byte[] getData(int var1, int var2);

    public void setData(int var1, byte[] var2);

    public int getAddressMax();

    public static class PlcWordMemory
    implements PlcMemory,
    Serializable {
        private byte[] data;

        public PlcWordMemory() {
        }

        public PlcWordMemory(int wordSize) {
            this.data = new byte[wordSize * 2];
        }

        public byte[] getData(int addr, int wsize) {
            if (this.data.length < addr * 2 + wsize * 2) {
                return null;
            }
            byte[] ret = new byte[wsize * 2];
            System.arraycopy(this.data, addr * 2, ret, 0, wsize * 2);
            return ret;
        }

        public void setData(int addr, byte[] srcdata) {
            System.arraycopy(srcdata, 0, this.data, addr * 2, srcdata.length);
        }

        public int getAddressMax() {
            return this.data.length / 2 - 1;
        }
    }

    public static class PlcBitMemory
    implements PlcMemory,
    Serializable {
        private boolean[] data;

        public PlcBitMemory() {
        }

        public PlcBitMemory(int bitSize) {
            this.data = new boolean[bitSize + 1];
        }

        public byte[] getData(int addr, int wsize) {
            if (this.data.length < addr + wsize * 16) {
                return null;
            }
            byte[] ret = new byte[wsize * 2];
            int i = 0;
            while (i + 1 < ret.length) {
                int offset = addr + i * 8;
                ret[i + 1] = this.getByte(offset);
                ret[i] = this.getByte(offset + 8);
                i += 2;
            }
            return ret;
        }

        public void setData(int addr, byte[] srcdata) {
            int i = 0;
            while (i + 1 < srcdata.length) {
                int offset = addr + i * 8;
                this.setByte(offset, srcdata[i + 1]);
                this.setByte(offset + 8, srcdata[i]);
                i += 2;
            }
        }

        public int getAddressMax() {
            return this.data.length - 17;
        }

        private byte getByte(int addr) {
            int mask = 1;
            byte ret = 0;
            for (int i = addr; i < addr + 8; ++i) {
                if (this.data[i]) {
                    ret = (byte)(ret | mask);
                }
                mask <<= 1;
            }
            return ret;
        }

        private void setByte(int addr, byte srcData) {
            int mask = 1;
            for (int i = addr; i < addr + 8; ++i) {
                this.data[i] = (srcData & mask) != 0;
                mask <<= 1;
            }
        }
    }
}

