/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.DelayQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Delayed;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private static final long NANO_ORIGIN = Utils.nanoTime();
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown;

    final long now() {
        return Utils.nanoTime() - NANO_ORIGIN;
    }

    private final void delayedExecute(Runnable command) {
        if (this.isShutdown()) {
            this.reject(command);
            return;
        }
        if (this.getPoolSize() < this.getCorePoolSize()) {
            this.prestartCoreThread();
        }
        super.getQueue().add(command);
    }

    private final void cancelUnwantedTasks() {
        boolean keepDelayed = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean keepPeriodic = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!keepDelayed && !keepPeriodic) {
            super.getQueue().clear();
        } else if (keepDelayed || keepPeriodic) {
            Object[] entries = super.getQueue().toArray();
            int i = 0;
            while (i < entries.length) {
                ScheduledFutureTask t;
                Object e = entries[i];
                if (e instanceof ScheduledFutureTask && ((t = (ScheduledFutureTask)e).isPeriodic() ? !keepPeriodic : !keepDelayed)) {
                    t.cancel(false);
                }
                ++i;
            }
            entries = null;
            this.purge();
        }
    }

    public boolean remove(Runnable task) {
        if (!(task instanceof ScheduledFutureTask)) {
            return false;
        }
        return this.getQueue().remove(task);
    }

    public ScheduledFuture schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        ScheduledFutureTask t = new ScheduledFutureTask(command, null, triggerTime);
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture schedule(Callable callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay < 0L) {
            delay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        ScheduledFutureTask t = new ScheduledFutureTask(callable, triggerTime);
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        ScheduledFutureTask t = new ScheduledFutureTask(command, null, triggerTime, unit.toNanos(period));
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        ScheduledFutureTask t = new ScheduledFutureTask(command, null, triggerTime, unit.toNanos(-delay));
        this.delayedExecute(t);
        return t;
    }

    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.schedule(command, 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Runnable task, Object result) {
        return this.schedule(Executors.callable(task, result), 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Callable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.continueExistingPeriodicTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.executeExistingDelayedTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    public void shutdown() {
        this.cancelUnwantedTasks();
        super.shutdown();
    }

    public List shutdownNow() {
        return super.shutdownNow();
    }

    public BlockingQueue getQueue() {
        return super.getQueue();
    }

    private final /* synthetic */ void this() {
        this.executeExistingDelayedTasksAfterShutdown = true;
    }

    public ScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayQueue());
        this.this();
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayQueue(), threadFactory);
        this.this();
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayQueue(), handler);
        this.this();
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayQueue(), threadFactory, handler);
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ScheduledFutureTask
    extends FutureTask
    implements ScheduledFuture {
        private final long sequenceNumber;
        private long time;
        private final long period;

        public long getDelay(TimeUnit unit) {
            long d = unit.convert(this.time - ScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
            return d;
        }

        public int compareTo(Object other) {
            return this.compareTo((Delayed)other);
        }

        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            ScheduledFutureTask x = (ScheduledFutureTask)other;
            long diff = this.time - x.time;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            if (this.sequenceNumber < x.sequenceNumber) {
                return -1;
            }
            return 1;
        }

        boolean isPeriodic() {
            boolean bl = false;
            if (this.period != 0L) {
                bl = true;
            }
            return bl;
        }

        private final void runPeriodic() {
            boolean ok = super.runAndReset();
            boolean down = ScheduledThreadPoolExecutor.this.isShutdown();
            if (ok && (!down || ScheduledThreadPoolExecutor.this.getContinueExistingPeriodicTasksAfterShutdownPolicy() && !ScheduledThreadPoolExecutor.this.isTerminating())) {
                long p = this.period;
                this.time = p > 0L ? (this.time += p) : ScheduledThreadPoolExecutor.this.now() - p;
                ScheduledThreadPoolExecutor.super.getQueue().add(this);
            } else if (down) {
                ScheduledThreadPoolExecutor.this.interruptIdleWorkers();
            }
        }

        public void run() {
            if (this.isPeriodic()) {
                this.runPeriodic();
            } else {
                super.run();
            }
        }

        ScheduledFutureTask(Runnable r, Object result, long ns) {
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable r, Object result, long ns, long period) {
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable callable, long ns) {
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }
    }
}

