/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.FIFOWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WaitQueue;
import java.io.Serializable;
import java.util.Collection;

public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Impl impl;

    public void acquire() throws InterruptedException {
        this.impl.acquire();
    }

    public void acquireUninterruptibly() {
        boolean wasInterrupted = false;
        while (true) {
            try {
                this.impl.acquire();
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
    }

    public boolean tryAcquire() {
        return this.impl.attempt();
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.impl.attempt(unit.toNanos(timeout));
    }

    public void release() {
        this.impl.release(1);
    }

    public void release(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.impl.release(permits);
    }

    public int availablePermits() {
        return this.impl.getPermits();
    }

    public int drainPermits() {
        return this.impl.drain();
    }

    protected void reducePermits(int reduction) {
        if (reduction < 0) {
            throw new IllegalArgumentException();
        }
        this.impl.reduce(reduction);
    }

    public boolean isFair() {
        return this.impl instanceof FairImpl;
    }

    public final boolean hasQueuedThreads() {
        return this.impl.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.impl.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.impl.getQueuedThreads();
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.impl.getPermits() + ']';
    }

    public Semaphore(int permits) {
        this.impl = new NonfairImpl(permits);
    }

    public Semaphore(int permits, boolean fair) {
        this.impl = fair ? new FairImpl(permits) : new NonfairImpl(permits);
    }

    static abstract class Impl
    implements Serializable {
        int permits_;

        abstract void acquire() throws InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean attempt() {
            Impl impl = this;
            synchronized (impl) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return true;
                }
                return false;
            }
        }

        abstract boolean attempt(long var1) throws InterruptedException;

        abstract void release(int var1);

        public synchronized int getPermits() {
            return this.permits_;
        }

        public synchronized int drain() {
            int acquired = this.permits_;
            this.permits_ = 0;
            return acquired;
        }

        public synchronized void reduce(int reduction) {
            this.permits_ -= reduction;
        }

        abstract boolean hasQueuedThreads();

        abstract int getQueueLength();

        abstract Collection getQueuedThreads();

        protected Impl(int permits) {
            this.permits_ = permits;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static final class FairImpl
    extends Impl
    implements WaitQueue.QueuedSync,
    Serializable {
        WaitQueue wq_;

        public final void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck()) {
                return;
            }
            WaitQueue.WaitNode w = new WaitQueue.WaitNode();
            w.doWait(this);
        }

        public final boolean attempt(long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck()) {
                return true;
            }
            if (nanos <= 0L) {
                return false;
            }
            WaitQueue.WaitNode w = new WaitQueue.WaitNode();
            return w.doTimedWait(this, nanos);
        }

        protected final synchronized boolean precheck() {
            boolean pass;
            boolean bl = false;
            if (this.permits_ > 0) {
                bl = true;
            }
            if (pass = bl) {
                --this.permits_;
            }
            return pass;
        }

        public final synchronized boolean recheck(WaitQueue.WaitNode w) {
            boolean pass;
            boolean bl = false;
            if (this.permits_ > 0) {
                bl = true;
            }
            if (pass = bl) {
                --this.permits_;
            } else {
                this.wq_.insert(w);
            }
            return pass;
        }

        public final void takeOver(WaitQueue.WaitNode n) {
        }

        protected final synchronized WaitQueue.WaitNode getSignallee() {
            WaitQueue.WaitNode w = this.wq_.extract();
            if (w == null) {
                ++this.permits_;
            }
            return w;
        }

        public final void release() {
            WaitQueue.WaitNode w;
            do {
                if ((w = this.getSignallee()) != null) continue;
                return;
            } while (!w.signal(this));
        }

        public final void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            int i = 0;
            while (i < n) {
                this.release();
                ++i;
            }
        }

        public final synchronized boolean hasQueuedThreads() {
            return this.wq_.hasNodes();
        }

        public final synchronized int getQueueLength() {
            return this.wq_.getLength();
        }

        public final synchronized Collection getQueuedThreads() {
            return this.wq_.getWaitingThreads();
        }

        private final /* synthetic */ void this() {
            this.wq_ = new FIFOWaitQueue();
        }

        FairImpl(int initialPermits) {
            super(initialPermits);
            this.this();
        }
    }

    static final class NonfairImpl
    extends Impl
    implements Serializable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            NonfairImpl nonfairImpl = this;
            synchronized (nonfairImpl) {
                try {
                    while (true) {
                        if (this.permits_ > 0) {
                            --this.permits_;
                            break;
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
                return;
            }
        }

        /*
         * Exception decompiling
         */
        public final boolean attempt(long nanos) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [8 : 24->120)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public final synchronized void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            this.permits_ += n;
            int i = 0;
            while (i < n) {
                this.notify();
                ++i;
            }
        }

        public final boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public final int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public final Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        protected NonfairImpl(int initialPermits) {
            super(initialPermits);
        }
    }
}

