/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.AbstractExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.security.AccessController;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final Runnable[] EMPTY_RUNNABLE_ARRAY;
    private static final RuntimePermission shutdownPerm;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private static final RejectedExecutionHandler defaultHandler;
    private final BlockingQueue workQueue;
    private final ReentrantLock mainLock;
    private final Condition termination;
    private final HashSet workers;
    private volatile long keepAliveTime;
    private boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    volatile int runState;
    private volatile RejectedExecutionHandler handler;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final /* synthetic */ boolean assert;

    void reject(Runnable command) {
        this.handler.rejectedExecution(command, this);
    }

    private final Thread addThread(Runnable firstTask) {
        Worker w = new Worker(firstTask);
        Thread t = this.threadFactory.newThread(w);
        if (t != null) {
            w.thread = t;
            this.workers.add(w);
            int nt = ++this.poolSize;
            if (nt > this.largestPoolSize) {
                this.largestPoolSize = nt;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean addIfUnderCorePoolSize(Runnable firstTask) {
        Thread t = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.corePoolSize) {
                t = this.addThread(firstTask);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            mainLock.unlock();
            throw throwable;
        }
        {
            Object var5_6 = null;
            mainLock.unlock();
            if (t == null) {
                return false;
            }
            t.start();
            return true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Runnable addIfUnderMaximumPoolSize(Runnable firstTask) {
        Thread t = null;
        Runnable next = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.maximumPoolSize) {
                next = (Runnable)this.workQueue.poll();
                if (next == null) {
                    next = firstTask;
                }
                t = this.addThread(next);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            mainLock.unlock();
            throw throwable;
        }
        {
            Object var6_7 = null;
            mainLock.unlock();
            if (t == null) {
                return null;
            }
            t.start();
            return next;
        }
    }

    /*
     * Exception decompiling
     */
    Runnable getTask() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CASE]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void interruptIdleWorkers() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            Iterator w = this.workers.iterator();
            while (w.hasNext()) {
                ((Worker)w.next()).interruptIfIdle();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            mainLock.unlock();
            throw throwable;
        }
        {
            Object var3_5 = null;
            mainLock.unlock();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void workerDone(Worker w) {
        ReentrantLock mainLock;
        block12: {
            block11: {
                block10: {
                    mainLock = this.mainLock;
                    mainLock.lock();
                    try {
                        this.completedTaskCount += w.completedTasks;
                        this.workers.remove(w);
                        if (--this.poolSize > 0) {
                            Object var4_3 = null;
                            mainLock.unlock();
                            return;
                        }
                        int state = this.runState;
                        if (!assert && state == 3) {
                            throw new AssertionError();
                        }
                        if (state != 2) {
                            if (!this.workQueue.isEmpty()) {
                                Thread t = this.addThread(null);
                                if (t != null) {
                                    t.start();
                                }
                                break block10;
                            }
                            if (state == 0) {
                                break block11;
                            }
                        }
                        this.termination.signalAll();
                        this.runState = 3;
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        mainLock.unlock();
                        throw throwable;
                    }
                }
                Object var4_4 = null;
                mainLock.unlock();
                return;
            }
            Object var4_5 = null;
            mainLock.unlock();
            return;
        }
        Object var4_7 = null;
        mainLock.unlock();
        if (!assert && this.runState != 3) {
            throw new AssertionError();
        }
        this.terminated();
    }

    public void execute(Runnable command) {
        Runnable r;
        if (command == null) {
            throw new NullPointerException();
        }
        do {
            if (this.runState != 0) {
                this.reject(command);
                return;
            }
            if (this.poolSize < this.corePoolSize && this.addIfUnderCorePoolSize(command)) {
                return;
            }
            if (this.workQueue.offer(command)) {
                return;
            }
            r = this.addIfUnderMaximumPoolSize(command);
            if (r != command) continue;
            return;
        } while (r != null);
        this.reject(command);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        security = System.getSecurityManager();
        if (security != null) {
            AccessController.checkPermission(ThreadPoolExecutor.shutdownPerm);
        }
        fullyTerminated = false;
        mainLock = this.mainLock;
        mainLock.lock();
        try {
            block11: {
                if (this.workers.size() <= 0) break block11;
                if (security != null) {
                    i = this.workers.iterator();
                    while (i.hasNext()) {
                        w = (Worker)i.next();
                        security.checkAccess(w.thread);
                    }
                }
                if ((state = this.runState) == 0) {
                    this.runState = 1;
                }
                try {
                    i = this.workers.iterator();
                    while (i.hasNext()) {
                        w = (Worker)i.next();
                        w.interruptIfIdle();
                    }
                    ** GOTO lbl-1000
                }
                catch (SecurityException se) {
                    this.runState = state;
                    throw se;
                }
            }
            fullyTerminated = true;
            this.runState = 3;
            this.termination.signalAll();
        }
        catch (Throwable var4_9) {
            var5_10 = null;
            mainLock.unlock();
            throw var4_9;
        }
lbl-1000:
        // 2 sources

        {
            var5_11 = null;
            mainLock.unlock();
            if (fullyTerminated) {
                this.terminated();
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List shutdownNow() {
        block10: {
            security = System.getSecurityManager();
            if (security != null) {
                AccessController.checkPermission(ThreadPoolExecutor.shutdownPerm);
            }
            fullyTerminated = false;
            mainLock = this.mainLock;
            mainLock.lock();
            try {
                block11: {
                    if (this.workers.size() <= 0) break block11;
                    if (security != null) {
                        w = this.workers.iterator();
                        while (w.hasNext()) {
                            security.checkAccess(((Worker)w.next()).thread);
                        }
                    }
                    if ((state = this.runState) != 3) {
                        this.runState = 2;
                    }
                    try {
                        w = this.workers.iterator();
                        while (w.hasNext()) {
                            ((Worker)w.next()).interruptNow();
                        }
                        ** GOTO lbl-1000
                    }
                    catch (SecurityException se) {
                        this.runState = state;
                        throw se;
                    }
                }
                fullyTerminated = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            catch (Throwable var4_8) {
                var5_9 = null;
                mainLock.unlock();
                throw var4_8;
            }
lbl-1000:
            // 2 sources

            {
                var5_10 = null;
                mainLock.unlock();
                if (!fullyTerminated) break block10;
                this.terminated();
            }
        }
        return Arrays.asList(this.workQueue.toArray(ThreadPoolExecutor.EMPTY_RUNNABLE_ARRAY));
    }

    public boolean isShutdown() {
        boolean bl = false;
        if (this.runState != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isTerminating() {
        boolean bl = false;
        if (this.runState == 2) {
            bl = true;
        }
        return bl;
    }

    public boolean isTerminated() {
        boolean bl = false;
        if (this.runState == 3) {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean bl;
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                if (this.runState == 3) {
                    boolean bl2 = true;
                    Object var8_8 = null;
                    mainLock.unlock();
                    return bl2;
                }
                if (nanos <= 0L) {
                    bl = false;
                    break;
                }
                this.termination.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            mainLock.unlock();
            throw throwable;
        }
        Object var8_9 = null;
        mainLock.unlock();
        return bl;
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public BlockingQueue getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable task) {
        return this.getQueue().remove(task);
    }

    public void purge() {
        try {
            Iterator it = this.getQueue().iterator();
            while (it.hasNext()) {
                Future c;
                Runnable r = (Runnable)it.next();
                if (!(r instanceof Future) || !(c = (Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        mainLock = this.mainLock;
        mainLock.lock();
        try {
            block7: {
                extra = this.corePoolSize - corePoolSize;
                this.corePoolSize = corePoolSize;
                if (extra >= 0) break block7;
                n = this.workQueue.size();
                while (extra++ < 0 && n-- > 0 && this.poolSize < corePoolSize && (t = this.addThread(null)) != null) {
                    t.start();
                }
                ** GOTO lbl-1000
            }
            if (extra > 0 && this.poolSize > corePoolSize) {
                it = this.workers.iterator();
                while (it.hasNext() && extra-- > 0 && this.poolSize > corePoolSize && this.workQueue.remainingCapacity() == 0) {
                    ((Worker)it.next()).interruptIfIdle();
                }
            }
        }
        catch (Throwable var3_7) {
            var4_8 = null;
            mainLock.unlock();
            throw var3_7;
        }
lbl-1000:
        // 2 sources

        {
            var4_9 = null;
            mainLock.unlock();
            return;
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return this.addIfUnderCorePoolSize(null);
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addIfUnderCorePoolSize(null)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean value) {
        this.allowCoreThreadTimeOut = value;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0) throw new IllegalArgumentException();
        if (maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int extra = this.maximumPoolSize - maximumPoolSize;
            this.maximumPoolSize = maximumPoolSize;
            if (extra > 0 && this.poolSize > maximumPoolSize) {
                Iterator it = this.workers.iterator();
                while (it.hasNext() && extra > 0 && this.poolSize > maximumPoolSize) {
                    ((Worker)it.next()).interruptIfIdle();
                    --extra;
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            mainLock.unlock();
            throw throwable;
        }
        {
            Object var4_7 = null;
            mainLock.unlock();
            return;
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        this.keepAliveTime = unit.toNanos(time);
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = 0;
            Iterator i = this.workers.iterator();
            while (i.hasNext()) {
                Worker w = (Worker)i.next();
                if (!w.isActive()) continue;
                ++n;
            }
            int n2 = n;
            Object var3_6 = null;
            mainLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLargestPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = this.largestPoolSize;
            Object var3_3 = null;
            mainLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            Iterator i = this.workers.iterator();
            while (i.hasNext()) {
                Worker w = (Worker)i.next();
                n += w.completedTasks;
                if (!w.isActive()) continue;
                ++n;
            }
            long l = n + (long)this.workQueue.size();
            Object var3_6 = null;
            mainLock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            Iterator i = this.workers.iterator();
            while (i.hasNext()) {
                Worker w = (Worker)i.next();
                n += w.completedTasks;
            }
            long l = n;
            Object var3_6 = null;
            mainLock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected void terminated() {
    }

    private final /* synthetic */ void this() {
        this.mainLock = new ReentrantLock();
        this.termination = this.mainLock.newCondition();
        this.workers = new HashSet();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        this.this();
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (workQueue == null || threadFactory == null || handler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    static {
        assert = Class.forName("[Ledu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;").getComponentType().desiredAssertionStatus() ^ true;
        EMPTY_RUNNABLE_ARRAY = new Runnable[0];
        shutdownPerm = new RuntimePermission("modifyThread");
        defaultHandler = new AbortPolicy();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Worker
    implements Runnable {
        private final ReentrantLock runLock;
        private Runnable firstTask;
        volatile long completedTasks;
        Thread thread;

        boolean isActive() {
            return this.runLock.isLocked();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void interruptIfIdle() {
            ReentrantLock runLock = this.runLock;
            if (!runLock.tryLock()) return;
            try {
                this.thread.interrupt();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                runLock.unlock();
                throw throwable;
            }
            {
                Object var3_4 = null;
                runLock.unlock();
                return;
            }
        }

        void interruptNow() {
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void runTask(Runnable task) {
            ReentrantLock runLock = this.runLock;
            runLock.lock();
            try {
                if (ThreadPoolExecutor.this.runState == 2) {
                    Object var4_3 = null;
                    runLock.unlock();
                    return;
                }
                Thread.interrupted();
                boolean ran = false;
                ThreadPoolExecutor.this.beforeExecute(this.thread, task);
                try {
                    task.run();
                    ran = true;
                    ThreadPoolExecutor.this.afterExecute(task, null);
                    ++this.completedTasks;
                }
                catch (RuntimeException ex) {
                    if (ran) throw ex;
                    ThreadPoolExecutor.this.afterExecute(task, ex);
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                runLock.unlock();
                throw throwable;
            }
            {
                Object var4_5 = null;
                runLock.unlock();
                return;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Runnable task = this.firstTask;
                this.firstTask = null;
                while (task != null || (task = ThreadPoolExecutor.this.getTask()) != null) {
                    this.runTask(task);
                    task = null;
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                ThreadPoolExecutor.this.workerDone(this);
                throw throwable;
            }
            {
                Object var2_4 = null;
                ThreadPoolExecutor.this.workerDone(this);
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.runLock = new ReentrantLock();
        }

        Worker(Runnable firstTask) {
            this.this();
            this.firstTask = firstTask;
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException();
        }
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }
}

