/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jim;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataProvider;
import jp.gr.javacons.jim.DataProviderDoesNotSupportException;
import jp.gr.javacons.jim.Manager;
import jp.gr.javacons.jim.Utility;

public class DataProviderCustomizer
extends Panel
implements Customizer {
    private static final long serialVersionUID = 1121150734068274677L;
    private TextField dataProviderNameField;
    private Button newButton;
    private Button deleteButton;
    private List dataHolderList;
    private Label dataHolderTypeLabel;
    private ScrollPane scrollPane;
    private DataHolder[] dataHolders;
    private DataProvider dataProvider;
    private DataHolder dataHolder;
    private Vector listeners;
    static final ResourceBundle res = ResourceBundle.getBundle("jp.gr.javacons.jim.DataProviderCustomizerResBundle", Locale.getDefault());

    public DataProviderCustomizer() {
        this.setBackground(Color.lightGray);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 2;
        Label l = new Label(res.getString("dpn"));
        gbl.setConstraints(l, c);
        this.add(l);
        c.weightx = 1.0;
        c.gridx = 2;
        c.gridwidth = 3;
        this.dataProviderNameField = new TextField();
        this.dataProviderNameField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DataProviderCustomizer.this.dataProviderNameChanged(((TextField)e.getSource()).getText());
            }
        });
        gbl.setConstraints(this.dataProviderNameField, c);
        this.add(this.dataProviderNameField);
        c.weightx = 0.0;
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 3;
        l = new Label(res.getString("dhs"));
        gbl.setConstraints(l, c);
        this.add(l);
        c.gridy = 2;
        c.gridx = 0;
        c.gridwidth = 1;
        this.newButton = new Button(res.getString("new."));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataProviderCustomizer.this.doNew();
            }
        });
        gbl.setConstraints(this.newButton, c);
        this.add(this.newButton);
        c.gridx = 1;
        c.gridwidth = 1;
        this.deleteButton = new Button(res.getString("del."));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataProviderCustomizer.this.doDelete();
            }
        });
        gbl.setConstraints(this.deleteButton, c);
        this.add(this.deleteButton);
        c.gridx = 2;
        l = new Label(res.getString("dht"));
        gbl.setConstraints(l, c);
        this.add(l);
        c.gridx = 3;
        c.weightx = 1.0;
        this.dataHolderTypeLabel = new Label();
        gbl.setConstraints(this.dataHolderTypeLabel, c);
        this.add(this.dataHolderTypeLabel);
        c.gridy = 3;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.dataHolderList = new List();
        this.dataHolderList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DataProviderCustomizer.this.dataHolderSelected();
            }
        });
        gbl.setConstraints(this.dataHolderList, c);
        this.add(this.dataHolderList);
        c.gridx = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.scrollPane = new ScrollPane(1){
            private static final long serialVersionUID = 793733517511089294L;

            public Dimension getMinimumSize() {
                return new Dimension(400, 150);
            }

            public Dimension getPreferredSize() {
                return new Dimension(400, 150);
            }
        };
        gbl.setConstraints(this.scrollPane, c);
        this.add(this.scrollPane);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(l);
    }

    void dataHolderSelected() {
        this.dataHolder = this.dataHolders[this.dataHolderList.getSelectedIndex()];
        this.setupDataHolderPropertyEditor();
    }

    void dataProviderNameChanged(String name) {
        if (Manager.getInstance().canSetDataProviderName(this.dataProvider, name)) {
            this.dataProvider.setDataProviderName(name);
        } else {
            Utility.showMessage(Utility.getRootFrame(this), res.getString("bad_dpn"));
            this.dataProviderNameField.setText(this.dataProvider.getDataProviderName());
        }
        this.firePropertyChange();
    }

    void doDelete() {
        Frame parent = Utility.getRootFrame(this);
        DataHolder dh = Utility.getDataProviderCustomizerHelper(this.dataProvider).removeDataHolder(parent, this.dataProvider, this.dataHolder);
        if (dh == null) {
            return;
        }
        try {
            this.dataProvider.removeDataHolder(dh);
            this.firePropertyChange();
            this.dataHolder = null;
            this.setupDataHolders();
        }
        catch (DataProviderDoesNotSupportException ex) {
            Utility.showMessage(Utility.getRootFrame(this), res.getString("not_del"));
        }
    }

    void doNew() {
        Frame parent = Utility.getRootFrame(this);
        DataHolder newDH = Utility.getDataProviderCustomizerHelper(this.dataProvider).addNewDataHolder(parent, this.dataProvider, this.getSelectableDataHolderTypeInfo());
        if (newDH == null) {
            return;
        }
        this.firePropertyChange();
        this.setupDataHolders();
        this.dataHolder = newDH;
        int index = -1;
        for (int i = 0; index < 0 || i < this.dataHolders.length; ++i) {
            if (this.dataHolders[i] != newDH) continue;
            index = i;
        }
        this.dataHolderList.select(index);
        this.setupDataHolderPropertyEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange() {
        Object[] targets;
        DataProviderCustomizer dataProviderCustomizer = this;
        synchronized (dataProviderCustomizer) {
            if (this.listeners == null) {
                return;
            }
            targets = new PropertyChangeListener[this.listeners.size()];
            this.listeners.copyInto(targets);
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, null, null, null);
        for (int i = targets.length - 1; 0 <= i; --i) {
            targets[i].propertyChange(evt);
        }
    }

    Class[][] getSelectableDataHolderTypeInfo() {
        Vector<Class[]> sVect = new Vector<Class[]>();
        Class[][] pType = this.dataProvider.getProvidableDataHolderTypeInfoByUser();
        for (int i = 0; i < pType.length; ++i) {
            Class[] pvs = pType[i];
            Class dhType = pvs[0];
            for (int j = 1; j < pvs.length; ++j) {
                sVect.addElement(new Class[]{dhType, pvs[j]});
            }
        }
        Class[][] sType = new Class[sVect.size()][];
        sVect.copyInto((Object[])sType);
        return sType;
    }

    String getTypeString(Class dataHolderClass, Class valueClass) {
        String tStr = this.dataProvider.getDataHolderTypeString(dataHolderClass, valueClass);
        if (tStr == null) {
            tStr = Manager.getInstance().getDefaultDataHolderTypeString(dataHolderClass, valueClass);
        }
        return tStr;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(l);
    }

    public void setObject(Object dataProvider) {
        this.dataProvider = (DataProvider)dataProvider;
        this.newButton.setEnabled(this.dataProvider.canAddDataHolderByUser());
        this.dataProviderNameField.setText(this.dataProvider.getDataProviderName());
        this.setupDataHolders();
    }

    void setupDataHolderPropertyEditor() {
        if (this.dataHolder == null) {
            this.deleteButton.setEnabled(false);
            this.dataHolderTypeLabel.setText("");
            this.showDataHolderPropertyEditor(null);
            return;
        }
        this.dataHolderTypeLabel.setText(this.getTypeString(this.dataHolder.getClass(), this.dataHolder.getValueClass()));
        Component c = Manager.getDataHolderPropertyListPanel(this.dataHolder);
        this.deleteButton.setEnabled(this.dataProvider.canRemoveDataHolderByUser(this.dataHolder));
        this.showDataHolderPropertyEditor(c);
    }

    void setupDataHolders() {
        this.dataHolders = this.dataProvider.getDataHolders();
        Utility.sort(this.dataHolders, new Utility.Comparator(){

            public int compare(Object o1, Object o2) {
                return ((DataHolder)o1).getDataHolderName().compareTo(((DataHolder)o2).getDataHolderName());
            }
        });
        this.dataHolderList.removeAll();
        for (int i = 0; i < this.dataHolders.length; ++i) {
            this.dataHolderList.add(this.dataHolders[i].getDataHolderName());
        }
        this.setupDataHolderPropertyEditor();
    }

    void showDataHolderPropertyEditor(Component component) {
        this.scrollPane.setVisible(false);
        this.scrollPane.removeAll();
        if (component != null) {
            this.scrollPane.add(component);
        }
        this.scrollPane.validate();
        this.scrollPane.setVisible(true);
    }

    void showErrorMessage(String message) {
        this.dataHolderTypeLabel.setText("");
        this.showDataHolderPropertyEditor(new Label(message));
    }
}

