/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jim;

import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditor;

class PropertyText
extends TextField
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = -7190045591062015560L;
    private PropertyEditor editor;
    private String originalText;

    PropertyText(PropertyEditor pe) {
        this.originalText = pe.getAsText();
        this.setText(this.originalText);
        this.editor = pe;
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (!this.originalText.equals(this.getText())) {
                this.editor.setAsText(this.getText());
            }
        }
        catch (IllegalArgumentException ex) {
            this.repaint();
            this.requestFocus();
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        try {
            if (!this.originalText.equals(this.getText())) {
                this.editor.setAsText(this.getText());
            }
        }
        catch (IllegalArgumentException ex) {
            this.repaint();
            this.requestFocus();
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void repaint() {
        this.setText(this.editor.getAsText());
    }
}

