/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.AbstractS2ContainerBuilder;
import org.seasar.framework.container.factory.S2ContainerTagHandlerRule;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.SAXParserFactoryUtil;
import org.seasar.framework.xml.SaxHandler;
import org.seasar.framework.xml.SaxHandlerParser;
import org.seasar.framework.xml.TagHandlerContext;

public class XmlS2ContainerBuilder
extends AbstractS2ContainerBuilder {
    public static final String PUBLIC_ID = "-//SEASAR//DTD S2Container//EN";
    public static final String PUBLIC_ID21 = "-//SEASAR2.1//DTD S2Container//EN";
    public static final String PUBLIC_ID23 = "-//SEASAR//DTD S2Container 2.3//EN";
    public static final String DTD_PATH = "org/seasar/framework/container/factory/components.dtd";
    public static final String DTD_PATH21 = "org/seasar/framework/container/factory/components21.dtd";
    public static final String DTD_PATH23 = "org/seasar/framework/container/factory/components23.dtd";
    protected S2ContainerTagHandlerRule rule = new S2ContainerTagHandlerRule();

    public S2ContainerTagHandlerRule getRule() {
        return this.rule;
    }

    public void setRule(S2ContainerTagHandlerRule rule) {
        this.rule = rule;
    }

    public S2Container build(String path) {
        return this.parse(null, path);
    }

    public S2Container include(S2Container parent, String path) {
        S2Container child = this.parse(parent, path);
        parent.include(child);
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected S2Container parse(S2Container parent, String path) {
        SaxHandlerParser parser = this.createSaxHandlerParser(parent, path);
        InputStream is = this.getInputStream(path);
        try {
            S2Container s2Container = (S2Container)parser.parse(is);
            return s2Container;
        }
        finally {
            InputStreamUtil.close(is);
        }
    }

    protected SaxHandlerParser createSaxHandlerParser(S2Container parent, String path) {
        SAXParserFactory factory = SAXParserFactoryUtil.newInstance();
        factory.setValidating(true);
        SAXParser saxParser = SAXParserFactoryUtil.newSAXParser(factory);
        SaxHandler handler = new SaxHandler(this.rule);
        handler.registerDtdPath(PUBLIC_ID, DTD_PATH);
        handler.registerDtdPath(PUBLIC_ID21, DTD_PATH21);
        handler.registerDtdPath(PUBLIC_ID23, DTD_PATH23);
        TagHandlerContext ctx = handler.getTagHandlerContext();
        ctx.addParameter("parent", parent);
        ctx.addParameter("path", path);
        return new SaxHandlerParser(handler, saxParser);
    }
}

