/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.component.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.EmptyRuntimeException;

public class SelectableDataSourceProxy
implements DataSource {
    private final S2Container container;
    private final ThreadLocal context = new ThreadLocal();

    public SelectableDataSourceProxy(S2Container container) {
        this.container = container;
    }

    public String getDataSourceName() {
        return (String)this.context.get();
    }

    public void setDataSourceName(String dataSourceName) {
        this.context.set(dataSourceName);
    }

    public DataSource getDataSource() {
        String dataSourceName = this.getDataSourceName();
        if (dataSourceName == null) {
            throw new EmptyRuntimeException("dataSourceName");
        }
        return (DataSource)this.container.getComponent((Object)dataSourceName);
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDataSource().getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDataSource().setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDataSource().setLoginTimeout(seconds);
    }
}

