#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QClipboard>
#include <QModelIndex>
#include <QTextStream>

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private slots:
    void on_picList_clicked(const QModelIndex &index);

    void on_picList_doubleClicked();

    void on_cateList_currentIndexChanged(int index);

    void on_fontList_currentFontChanged(const QFont &f);

    void on_spinFontSize_valueChanged(int arg1);

    void on_radRHand_toggled();

    void on_radRShake_toggled();

    void on_radRSurp_toggled();

    void on_radRGood_toggled();

    void on_radRVGood_toggled();

    void on_radLHand_toggled();

    void on_radLShake_toggled();

    void on_groupR_toggled();

    void on_groupL_toggled();

private:
    Ui::MainWindow *ui;
    QString folder;
    QClipboard *clipboard;
    QFont font;
    bool init;

    void Init();
    void Search(int index);
    void RadioBtnManage();
    QString RadioBtnRManage();
    QString RadioBtnLManage();
};

#endif // MAINWINDOW_H
