#define _XOPEN_SOURCE

#include "ch_time_and_mod_dir.h"
#include "global.h"

#include <stdio.h>
#include <stdlib.h>

#include <signal.h>
#include <unistd.h>

// 関数プロトタイプ
void set_signal(void);
void handler(int sig);

/*******************************************************************************
*******************************************************************************/
void set_signal(void)
{
	// シグナルハンドラ
	struct sigaction act;
	act.sa_handler = handler;
	act.sa_flags = 0;
	sigaction(SIGINT, &act, NULL);
	sigaction(SIGTERM, &act, NULL);
	sigaction(SIGSEGV, &act, NULL);
	sigaction(SIGBUS, &act, NULL);
	sigaction(SIGKILL, &act, NULL);
	sigaction(SIGABRT, &act, NULL);
	sigaction(SIGQUIT, &act, NULL);
	sigaction(SIGHUP, &act, NULL);
}

/*******************************************************************************
 * シグナルを受け取ったら、コピー中のファイルを削除して終了する
*******************************************************************************/
void handler(int sig)
{
	fprintf(stderr, "\n");
	fprintf(stderr, "ERROR!");
	fprintf(stderr, "signal number = %d\n", sig);

	if(write_now != NULL)
	{
		unlink(write_now);
	}

	if((stat_target_directory != NULL) && (stat_data != NULL))
	{
		ch_time_and_mod_dir(stat_target_directory, stat_data);
	}

	exit(EXIT_FAILURE);
}
