#define _GNU_SOURCE

#include "global.h"
#include "md5.h"
#include "set_signal.h"

#include <stdbool.h>
#include <stdlib.h>
#include <string.h>

#include <errno.h>
#include <fcntl.h>
#include <malloc.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#define BUF_NUM 2

static void *buf[BUF_NUM];
static int fd;
static int buffer_size_local;
static long psize;
static md5_state_t state;
static md5_byte_t digest[16];
static int read_size[BUF_NUM];
static off_t total;
static off_t static_to_size;
static int r_number;
static int a_number;
static _Bool lseek_err;
static _Bool read_err;
static _Bool read_finish;

// 関数プロトタイプ
_Bool verify_hash(const char *filename, const off_t size, const char *md5hash);
static void * read_func(void *dummy);
static void * append_func(void *dummy);

/*******************************************************************************
*******************************************************************************/
_Bool verify_hash(const char *filename, const off_t size, const char *md5hash)
{
	fd = 0;
	buffer_size_local = BUF_SIZE / 2;
	read_size[0] = 0;
	read_size[1] = 0;
	total = 0;
	static_to_size = size;
	lseek_err = false;
	read_err = false;
	read_finish = false;

	static _Bool get_memory = false;
	_Bool open_flag = false;
	_Bool verify_success = false;

	if(psize == 0)
	{
		psize = sysconf(_SC_PAGESIZE);
	}

	errno = 0;
	if((fd = open(filename, O_NOATIME | O_NOFOLLOW | O_DIRECT | O_RDONLY)) == -1)
	{
		perror("open");
		handler(errno);
		exit(EXIT_FAILURE);
	}
	else
	{
		open_flag = true;
	}

	if(open_flag == true)
	{
		if((buf[0] == NULL) && (buf[1] == NULL))
		{
			if((posix_memalign((void **)&buf[0], psize, buffer_size_local) == 0) && (posix_memalign((void **)&buf[1], psize, buffer_size_local) == 0))
			{
				get_memory = true;
			}
			else
			{
				perror("posix_memalign");
				handler(errno);
				exit(EXIT_FAILURE);
			}
		}

		if(get_memory == true)
		{
			md5_init(&state);

			r_number = 0;
			a_number = 1;
			pthread_t t1;
			pthread_t t2;

			pthread_create(&t1, NULL, read_func, (void *)&r_number);
			pthread_join(t1, NULL);

			for(;;)
			{
				r_number++;
				a_number--;
				pthread_create(&t1, NULL, read_func, (void *)&r_number);
				pthread_create(&t2, NULL, append_func, (void *)&a_number);

				pthread_join(t1, NULL);
				pthread_join(t2, NULL);

				if((read_finish == true) || (lseek_err == true) || (read_err == true))
				{
					break;
				}

				r_number--;
				a_number++;
				pthread_create(&t1, NULL, read_func, (void *)&r_number);
				pthread_create(&t2, NULL, append_func, (void *)&a_number);

				pthread_join(t1, NULL);
				pthread_join(t2, NULL);

				if((read_finish == true) || (lseek_err == true) || (read_err == true))
				{
					break;
				}
			}

			md5_finish(&state, digest);

			static char hex_output[(16 * 2) + 1];
			hex_output[0] = '\0';

			for(int di = 0; di < 16; ++di)
			{
				sprintf(hex_output + di * 2, "%02x", digest[di]);
			}

			if(strcmp(md5hash, hex_output) == 0)
			{
				verify_success = true;
			}
		}
	}

//	free(buf[0]);
//	free(buf[1]);

	if(open_flag == true)
	{
		if(close(fd) == -1)
		{
			perror("close");
		}
	}

	return verify_success;
}

/*******************************************************************************
*******************************************************************************/
static void * read_func(void *dummy)
{
	static int i;
	static int try_count;

	dummy++;// コンパイル時のwarningを出さないようにするため

	i = r_number;
	try_count = 0;

	for(;;)
	{
		read_size[i] = pread(fd, buf[i], buffer_size_local, total);

		if(read_size[i] == 0)
		{
			read_finish = true;
			break;
		}
		else if((read_size[i] % psize) == 0)
		{
			total += read_size[i];

			if(lseek(fd, read_size[i], SEEK_CUR) == -1)
			{
				lseek_err = true;
				break;
			}

			break;
		}
		else if((read_size[i] + total) >= static_to_size)
		{
			total += read_size[i];

			if(lseek(fd, read_size[i], SEEK_CUR) == -1)
			{
				lseek_err = true;
				break;
			}

			break;
		}
		else
		{
			try_count++;

			if(try_count >= 10)
			{
				read_err = true;
				break;
			}
			else
			{
				continue;
			}
		}
	}

	return NULL;
}

/*******************************************************************************
*******************************************************************************/
static void * append_func(void *dummy)
{
	static int i;
	i = a_number;

	md5_append(&state, buf[i], read_size[i]);

	dummy++;// コンパイル時のwarningを出さないようにするため

	return NULL;
}
