#define _GNU_SOURCE

#include "ch_time_and_mod_dir.h"
#include "cp.h"
#include "dir_traverse.h"
#include "filefrag_custom.h"
#include "global.h"
#include "help.h"
#include "set_signal.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <limits.h>

#include <errno.h>
#include <linux/limits.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <glib.h>
#include <getopt.h>

char *global_parent = ".";

_Bool flag_and_gigabyte = false;
_Bool flag_only_gigabyte = false;

/*******************************************************************************
*******************************************************************************/
void analyze_option(const int argc, char **argv)
{
	int result;

	while((result = getopt(argc, argv, "gGh")) != -1)
	{
		switch(result)
		{
		case 'g':
			flag_and_gigabyte = true;
			flag_only_gigabyte = false;
			break;
		case 'G':
			flag_only_gigabyte = true;
			flag_and_gigabyte = true;
			break;
		case 'h':
			help();
			exit(EXIT_SUCCESS);
			break;
		}
	}
}

/*******************************************************************************
*******************************************************************************/
int main(int argc, char **argv)
{
	if(argc == 1)
	{
		help();
		return EXIT_SUCCESS;
	}
	else
	{
		int current;

		if((current = open(".", O_RDONLY)) == -1)
		{
			perror("open");
			exit(EXIT_FAILURE);
		}

		set_signal();
		analyze_option(argc, argv);

		for(int i = 1; i <= argc; i++)
		{
			if(g_file_test(argv[i], G_FILE_TEST_IS_SYMLINK) == FALSE)
			{
				if(g_file_test(argv[i], G_FILE_TEST_IS_REGULAR) == TRUE)
				{
					int from_extents = filefrag_custom(argv[i]);
					global_parent = g_path_get_dirname(argv[i]);

					if(chdir(global_parent) == -1)
					{
						perror("chdir");
						exit(EXIT_FAILURE);
					}

					if(from_extents > 1)
					{
						cp(argv[i], from_extents);
					}

					free(global_parent);
					global_parent = ".";

					if(fchdir(current) == -1)
					{
						perror("fchdir");
						exit(EXIT_FAILURE);
					}
				}
				else if(g_file_test(argv[i], G_FILE_TEST_IS_DIR) == TRUE)
				{
					_Bool b = dir_traverse(argv[i]);

					if((b == true) && (fchdir(current) == -1))
					{
						perror("fchdir");
						exit(EXIT_FAILURE);
					}
				}
			}
			else
			{
				printf("スキップ : シンボリックリンク : %s\n", argv[i]);
			}
		}
	}

	return EXIT_SUCCESS;
}
