#define _GNU_SOURCE

#include "ch_time_and_mod_dir.h"
#include "cp.h"
#include "filefrag_custom.h"
#include "global.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include <errno.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <glib.h>

/*******************************************************************************
*******************************************************************************/
_Bool dir_traverse(const char *current_folder)
{
	if(chdir(current_folder) == -1)
	{
		perror("chdir");
		return false;
	}

	DIR *dp = NULL;
	struct dirent *entry = NULL;

	if((dp = opendir(".")) != NULL)
	{
		while((entry = readdir(dp)) != NULL)
		{
			// strcmpは等しければ0を返す（0は偽）
			if(strcmp(entry->d_name, ".") && strcmp(entry->d_name, ".."))
			{
				int from_extents;

				if(g_file_test(entry->d_name, G_FILE_TEST_IS_SYMLINK) == FALSE)
				{
					if(g_file_test(entry->d_name, G_FILE_TEST_IS_REGULAR) == TRUE)
					{
						from_extents = filefrag_custom(entry->d_name);

						if(from_extents > 1)
						{
							cp(entry->d_name, from_extents);
						}
					}
					else if(g_file_test(entry->d_name, G_FILE_TEST_IS_DIR) == TRUE)
					{
						// 再帰
						if(dir_traverse(entry->d_name) == true)
						{
							if(chdir("..") == -1)
							{
								perror("chdir");
								exit(EXIT_FAILURE);
							}
						}
					}
				}
			}
		}
		if(closedir(dp) == -1)
		{
			perror("closedir");
		}
	}
	else
	{
		perror("opendir");
	}

	return true;
}
