fcf.module({
  name:         "fcfControls:templates/int-edit.hooks.js",
  dependencies: [],
  module: function(){
    return {
      //
      // The hook is executed before assembling the template arguments. The function can be asynchronous
      //
      // hookBeforeBuild: (a_taskInfo) => {
      // },

      //
      // The hook is executed after assembling the template arguments. The function can be asynchronous
      //
      hookAfterBuild: async (a_taskInfo) => {
        let newValue = parseInt(a_taskInfo.args.emptyValue);
        if (!isNaN(newValue) && fcf.empty(a_taskInfo.args.value))
          await a_taskInfo.setValue("value", newValue);
        let numValue = parseInt(a_taskInfo.args.value);
        if ((isNaN(parseInt(numValue)) && !isNaN(parseInt(a_taskInfo.args.min))) || (numValue < a_taskInfo.args.min)){
          await a_taskInfo.setValue("value", a_taskInfo.args.min);
          await a_taskInfo.setValue("displayValue", a_taskInfo.args.min);
        } else if (!isNaN(parseInt(a_taskInfo.args.max)) && numValue > a_taskInfo.args.max){
          await a_taskInfo.setValue("value", a_taskInfo.args.max);
          await a_taskInfo.setValue("displayValue", a_taskInfo.args.max);
        }
      },

      //
      // The hook is executed after building the template's system arguments. The function can be asynchronous
      //
      // hookAfterSystemBuild: (a_taskInfo) => {
      // },

      //
      // The hook is called after the template is rendered. The function can be asynchronous
      //
      // hookAfterRender: (a_taskInfo) => {
      // },

      //
      // Object of hooks for programmatically populated arguments. The function can be asynchronous
      //
      // hooksProgramableArgument: {
      //   //
      //   // Hook of the assembly of a programmatically populated argument created by the fcf.argProg() method with the name ARG_NAME
      //   // The function can be asynchronous
      //   // @result Returns the value of an argument or a Promise object
      //   //
      //   ARG_NAME: (a_taskInfo) => {
      //   },
      // },

      //
      // Object of the hooks preprocessing of the template arguments
      //
      // hooksBeforeArgument: {
      //   //
      //   // A preprocessing hook for an argument named ARG_NAME. The function can be asynchronous
      //   //
      //   ARG_NAME: (a_taskInfo) => {
      //   },
      //
      //   //
      //   // This hook is called to pre-process each argument of the template. The function can be asynchronous
      //   //
      //   "*": (a_taskInfo)=>{
      //   },
      // },

      //
      // Object of the hooks postprocessing of the template arguments
      //
      // hooksAfterArgument: {
      //   //
      //   // A post-processing hook for an argument named ARG_NAME. The function can be asynchronous
      //   // @result It can return an argument value or an undefined value if the argument is not redefined.
      //   //
      //   ARG_NAME: (a_taskInfo) => {
      //   },
      //
      //   //
      //   // This hook is called for post-processing of each template argument. The function can be asynchronous
      //   // @result It can return an argument value or an undefined value if the argument is not redefined.
      //   //
      //   "*": (a_taskInfo)=>{
      //   },
      // },
    };
  }
});
