fcf.module({
  name: "fcfSimpleAuthorization:page_templates/registration-confirmation+body.hooks.js",
  dependencies: [],
  module: function(){

    fcf.addException("FCF_SIMPLE_AUTHORIZATION_EMPTY_TOKEN",                "A registration token is not specified");
    fcf.addException("FCF_SIMPLE_AUTHORIZATION_REGISTRATION_NOT_PERFORMED", "User registration is not performed");

    return {
      //
      // void hookBeforeBuild(a_taskInfo)
      // The hook is executed before assembling the template arguments
      //
      // hookBeforeBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after assembling the template arguments
      //
      hookAfterBuild: function(a_taskInfo) {
        let token     = a_taskInfo.route.args.token;
        let user      = a_taskInfo.route.args.user;
        let completed = false;

        if (fcf.empty(token))
          throw new fcf.Exception("FCF_SIMPLE_AUTHORIZATION_EMPTY_TOKEN");

        return fcf.actions()
        .then(()=>{
          return fcf.application.getStorage().query(
            "SELECT id, user->id AS user FROM ___fcfSimpleAuthorization___registration_requests WHERE token = ${1}", 
            [token],
            {roles: ["root"]});
        })
        .then((a_result)=>{
          if (!a_result[0][0]){
            return fcf.application.getStorage().query(
              "SELECT id FROM ___fcf___users WHERE user = ${1}",
              [user],
              {roles: ["root"]}
            )
            .then((a_records)=>{
              if (!a_records[0][0])
                throw new fcf.Exception("FCF_SIMPLE_AUTHORIZATION_REGISTRATION_NOT_PERFORMED");
              completed = true;
            })
          } else {
            return fcf.application.getStorage().query(
              "UPDATE ___fcf___users SET initialized = ${1} WHERE user = ${2};"+
              "DELETE FROM ___fcfSimpleAuthorization___registration_requests WHERE token = ${3}", 
              [true, user, token], 
              { roles: ["root"] });
          }
        })
        .then(()=>{
          a_taskInfo.args.completed = completed;
        })
      },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after building the template's system arguments
      //
      // hookAfterSystemBuild: function(a_taskInfo) {
      // },

      //
      // Object of hooks for programmatically populated arguments
      //
      // hooksProgrammableArgument: {
      //   //
      //   // @result Returns the value of an argument or a Promise object
      //   //
      //   "ARG_NAME": function(a_taskInfo){
      //   }
      // },

      //
      // Object of the hooks preprocessing of the template arguments
      //
      // hooksBeforeArgument: {
      //   // 
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   "ARG_NAME": function(a_taskInfo) {
      //   }
      // },

      //
      // Object of the hooks postprocessing of the template arguments
      // hooksAfterArgument: {
      //   //
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   "ARG_NAME": function(a_taskInfo) {
      //   }
      // },
    };
  }
});
