fcf.module({
  name: "fcf:NFSQL/NFunction/Key.js",
  dependencies: ["fcf:NFSQL/NFunction/Function.js"],
  module: function(Function, Errors) {
    var NFunction = fcf.prepareObject(fcf, "NFSQL.NFunction");

    NFunction.Key = function() {
      Function.call(this);

      this.processFunction = function(a_taskInfo, a_info){
        let from  = a_info.function.from ? a_info.function.from : a_taskInfo.query.from;
        let field = a_taskInfo.getProjection(from).key
        a_info.function.from  = from;
        a_info.function.field = field;
        delete a_info.function.function;
        delete a_info.function.args;

        let queryField = a_taskInfo.getQueryField(a_info.function);
        let queryTable = a_taskInfo.getQueryTableByField(a_info.function);

        a_info.function.from  = queryTable;
        a_info.function.field = queryField;
        a_info.function.recommendedAs = "key()";
      }

    }

    return NFunction.Key;
  }
});
