fcf.module({
  name: "fcfControls:templates/tabs.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class TabWrapper extends Wrapper{

      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onClick(a_event){
        this.setArg("tab", a_event.target.getAttribute("key"));
        if (this.getArg("reload")) {
          this.update({restoreChilds: false});
        } else {
          let tabs          = this.select(">div>div>div[tab]");
          let activeTab     = this.select(">div>div>div[tab][key='" + a_event.target.getAttribute("key") + "']")[0];
          let contents      = this.select(">div>div[content]");
          let activeContent = this.select(">div>div[content][key='" + a_event.target.getAttribute("key") + "']")[0];
          fcf.each(tabs, (a_key, a_tab)=>{ a_tab.classList.remove("active"); });
          activeTab.classList.add("active");
          fcf.each(contents, (a_key, a_content)=>{ a_content.classList.remove("active"); });
          activeContent.classList.add("active");
        }

      }

    };
  }
});
