fcf.module({
  name: "fcfDBControls:templates/select+menu.receive.js",
  dependencies: [],
  module: function() {
    return class Handler {
      receive(a_fields, a_files){
        let size   = fcf.range(a_fields.size, 0, 100);
        let offset = fcf.range(a_fields.offset, 0, 99999);
        let query  = {
          type:   "select",
          fields: [{function: "title", as: "@title"}, {function: "key", as: "@key"}],
          from:   a_fields.projection,
          offset: offset,
          limit:  size,
        };
        fcf.each(a_fields.fields, (k, field)=>{
          query.fields.push({field: field});
        });
        if (a_fields.find != "") {
          query.where = [{
            logic: "and",
            type:  "like",
            args: [{"function": "title"}, {"value": "%" + a_fields.find + "%"}]
          }];
        }
        return fcf.application.getStorage().query(query)
        .then((a_records)=>{
          return a_records[0];
        })
      }
    }
  }
});
