fcf.module({
  name: "fcf:NServer/NControllers/Page.js",
  dependencies: ["fcf:NServer/NControllers/Controller.js"],
  module: function(Controller) {
    fcf.prepareObject(fcf, "NServer.NControllers");

    fcf.NServer.NControllers.Page = class Page extends Controller {

      getRequestInfo(){
        return {
          userRequest: true,
          redirect:    false,
        };
      }

      action(a_request) {
        let self = this;

        let render = fcf.application.getRender();

        let modules = {};
        for(let k in fcf.settings.libraries) {
          let uri = fcf.getPath(k+":", false);
          modules[k] = uri.substr(0, 1) != "/" ? "/" + uri : uri;
        }

        let args = fcf.append({}, this._options.endpoint.args);

        fcf.application.render( {
                                  template:   this._options.endpoint.source,
                                  args:       args,
                                  root:       true,
                                  route:      a_request.getRoute(),
                                  request:    a_request,
                                  pageHeader: { title: fcf.getContext().route.title, description: fcf.getContext().route.description },
                                  onResult: function(a_error, a_template) {
                                      if (a_error) {
                                        a_request.sendErrorPage(a_error);
                                        return;
                                      }
                                      a_request.send(a_template.content);
                                    }
                                  } );
      }
    }

    return fcf.NServer.NControllers.Page;
  }
});
