fcf.module({
  name: "fcf:NServer/NControllers/Render.js",
  dependencies: ["fcf:NServer/NControllers/Controller.js",
                 "fcf:NServer/NControllers/Route.js"
                ],
  module: function(Controller, RouteController) {
    fcf.prepareObject(fcf, "NServer.NControllers");

    fcf.NServer.NControllers.Render = class Render extends Controller {

      getRequestInfo(){
        return {
          userRequest: true,
          redirect:    false,
        };
      }

      async action(a_request) {
        let args                = typeof a_request.getRoute().args.args == "object" ? a_request.getRoute().args.args : {};
        let template            = a_request.getRoute().args.template;
        let url                 = a_request.getRoute().args.url ? a_request.getRoute().args.url : fcf.getContext().route.url;
        let externalArgs        = a_request.getRoute().args.externalArgs;
        let rc                  = new RouteController({});
        let routeInfo           = url != fcf.getContext().route.url ? (await rc.getRoute(a_request, url)) : fcf.getContext().route;
        let originRoute         = fcf.getContext().route;
        for(let key in originRoute.args)
          if (!(key in routeInfo.args))
            routeInfo.args[key] = originRoute.args[key];

        fcf.application.render( {
                                  template:     template,
                                  args:         args,
                                  route:        routeInfo,
                                  request:      a_request,
                                  externalArgs: externalArgs,
                                  onResult: function(a_error, a_template) {
                                      if (a_error) {
                                        fcf.log.err("FCF:CONTROLLER:RENDER", a_error);
                                        a_request.sendError(a_error);
                                        return;
                                      }
                                      a_template.route = routeInfo;
                                      try {
                                        a_request.send(JSON.stringify(a_template));
                                      } catch(e){
                                        a_request.sendError(e);
                                      }
                                    }
                                  } );
      }
    }

    return fcf.NServer.NControllers.Render;
  }
});
