fcf.module({
  name: "fcfManagement:templates/pages/translations/translations-tab.hooks.js",
  dependencies: [],
  module: function(){
    return {
      //
      // void hookBeforeBuild(a_taskInfo)
      // The hook is executed before assembling the template arguments
      //
      // hookBeforeBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after assembling the template arguments
      //
      // hookAfterBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after building the template's system arguments
      //
      // hookAfterSystemBuild: function(a_taskInfo) {
      // },

      //
      // Object of hooks for programmatically populated arguments
      //
      hooksProgrammableArgument: {
        //
        // @result Returns the value of an argument or a Promise object
        //
        "files": (a_taskInfo)=>{
          return fcf.NTools.languages.getTranslationFiles();
        },
        "displayedFilesAll": (a_taskInfo)=>{
          let result = {};
          fcf.each(fcf.NTools.languages.getLanguages(), (language)=>{
            result[language] = [];
          });
          fcf.each(a_taskInfo.args.files, (k, file)=>{
            if (file.enable)
              result[file.language].push({path: file.path, editable: file.editable, enable: true});
          });
          return result;
        },
        "editableFile": (a_taskInfo) => {
          let language = a_taskInfo.args.language;
          for(let i = 0; i < a_taskInfo.args.displayedFilesAll[language].length; ++i)
            if (a_taskInfo.args.displayedFilesAll[language][i].editable)
              return a_taskInfo.args.displayedFilesAll[language][i].path;
        },
        "translations": (a_taskInfo)=>{
          return fcf.NTools.languages.getTranslationsEx()
          .then((a_translations)=>{
            result = {};
            fcf.each(a_translations, (a_language, a_translations)=>{
              result[a_language] = []
              fcf.each(a_translations, (a_phrase, a_translate)=>{
                a_translate.phrase = a_phrase;
                result[a_language].push(a_translate);
              });
            });
            return result;
          });
        },
        "translationsModify": (a_taskInfo)=>{
          let result = {};
          fcf.each(fcf.NTools.languages.getLanguages(), (language)=>{
            result[language] = {};
          });
          return result;
        },
        "translationsOrigin": (a_taskInfo)=>{
          return fcf.NTools.languages.getTranslationsByFiles()
          .then((a_translations)=>{

            result = {};
            fcf.each(a_translations, (a_language, a_translationsByFiles)=>{
              result[a_language] = {};
              let files = [];
              for(let file in a_translationsByFiles)
                files.push(file);
              for(let j = files.length-1; j >= 0; --j){
                let filePath = files[j];
                let translations = a_translationsByFiles[filePath];
                result[a_language][filePath] = [];
                fcf.each(translations, (a_phrase, a_translate)=>{
                  a_translate.phrase = a_phrase;
                  result[a_language][filePath].push(a_translate);
                });
              }
            });
            return result;
          });
        }
      },

      //
      // Object of the hooks preprocessing of the template arguments
      //
      // hooksBeforeArgument: {
      //   // 
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   "ARG_NAME": function(a_taskInfo) {
      //   }
      // },

      //
      // Object of the hooks postprocessing of the template arguments
      // hooksAfterArgument: {
      //   //
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   "ARG_NAME": function(a_taskInfo) {
      //   }
      // },
    };
  }
});
