fcf.module({
  name: "fcf:NServer/NControllers/Controller.js",
  dependencies: [],
  module: function() {
    var NControllers = fcf.prepareObject(fcf, "NServer.NControllers");

    NControllers.Controller = class Controller {

      /**
      / @var object _options - Controller options
      /         - fcf.RouteInfo route     - route info
      /         - object        endpoint  - endpoint info | settings
      **/

      /**
      / @param object a_options - Controller options
      /         - fcf.RouteInfo route     - route info
      /         - object        endpoint  - endpoint info | settings
      **/
      constructor(a_options) {
        this._options = a_options;
      }

      /**
      / @brief Get options for processing a request
      / @result object - options for processing a request
      /     - bool userRequest - information about a user is required to process the request
      /     - bool redirect       - the controller uses a redirect in the actions method
      **/
      getRequestInfo(){
        return {
          userRequest: true,
          redirect:    false,
        };
      }


      action(a_request) {
        a_request.next();
      }
    }

    return NControllers.Controller;
  }
});
