fcf.module({
  name:         "fcfBackup:templates/management/backup+body.receive.js",
  dependencies: ["fcfBackup:Tools/backup.js"],
  lazy:         [],
  module: function(backup) {
    return class Handler {
      async receive(a_data, a_files){
        switch(a_data.type){
          case "save_config":
            return this.saveConfig(a_data.config);
          case "create_backup":
            return this.backup();
        }
      }

      async saveConfig(a_config){
        return fcf.application.setSystemVariable("fcfBackup:config", a_config);
      }

      async backup(){
        let id = await backup.saveApplicationFiles();
        await backup.createDBBackup(id);
      }
    }
  }
});
