fcf.module({
  name: "fcf:tests/NServer/Cron.js",
  dependencies: ["fcf:NTest/uniTest.js", 
                 "fcf:NSystem/Cron.js"],
  module: function(uniTest, Cron) {

    uniTest.add("NServer" , "Cron", function(a_tester) {
      let con = new Cron();
      uniTest.equal(con._equal("* * * * *", new Date("2019-12-1 05:05:05")), "* * * * *");
      uniTest.equal(con._equal("5 * * * *", new Date("2019-12-1 05:05:05")), "5 * * * *");
      uniTest.equal(con._equal("*/2 * * * *", new Date("2019-12-1 05:06:00")), "*/2 * * * *");
      uniTest.equal(con._equal("* 1,2,5,7 * * *", new Date("2019-12-1 05:05:00")), "* 1,2,5,7 * * *");
      uniTest.equal(con._equal("* 1,2,7 * * *", new Date("2019-12-1 05:05:00")), false);
      uniTest.equal(con._equal("* 1-7 * * *", new Date("2019-12-1 05:05:00")), "* 1-7 * * *");
      uniTest.equal(con._equal("* * 1 * *", new Date("2019-12-1 05:05:00")), "* * 1 * *");
      uniTest.equal(con._equal("* * 1,23 * *", new Date("2019-12-1 05:05:00")), "* * 1,23 * *");
      uniTest.equal(con._equal("* * 1-23 * *", new Date("2019-12-7 05:05:00")), "* * 1-23 * *");
      uniTest.equal(con._equal("* * 1-5 * *", new Date("2019-12-7 05:05:00")), false);
      uniTest.equal(con._equal("* * * 12 *", new Date("2019-12-7 05:05:00")), "* * * 12 *");
      uniTest.equal(con._equal("* * * 1-11 *", new Date("2019-12-7 05:05:00")), false);
      uniTest.equal(con._equal("* * * 1-12 *", new Date("2019-12-7 05:05:00")), "* * * 1-12 *");
      uniTest.equal(con._equal("* * * 1,11 *", new Date("2019-12-7 05:05:00")), false);
      uniTest.equal(con._equal("* * * 1,11,12 *", new Date("2019-12-7 05:05:00")), "* * * 1,11,12 *");
      uniTest.equal(con._equal("* * * 12 6", new Date("2019-12-7 05:05:00")), "* * * 12 6");
      uniTest.equal(con._equal("* * * 12 7", new Date("2019-12-8 05:05:00")), "* * * 12 7");
      uniTest.equal(con._equal("* * * 12 Sun", new Date("2019-12-8 05:05:00")), "* * * 12 7");
      uniTest.equal(con._equal("* * * 12 6", new Date("2019-12-8 05:05:00")), false);
      uniTest.equal(con._equal("* * * 12 0", new Date("2019-12-8 05:05:00")), "* * * 12 7");

      uniTest.equal(con._equal("? * * 12 0", new Date("2019-12-8 05:05:00")), "5 * * 12 7");
      uniTest.equal(con._equal("? * * * *", new Date("2019-12-8 05:05:00")), "5 * * * *");
      uniTest.equal(con._equal("? ? ? ? ?", new Date("2019-12-8 05:05:00")), "5 5 8 12 7");

    });

  }
});
