/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jibx.runtime.IAliasable;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class HashMapperStringToComplex
implements IMarshaller,
IUnmarshaller,
IAliasable {
    private static final String SIZE_ATTRIBUTE_NAME = "size";
    private static final String ENTRY_ELEMENT_NAME = "entry";
    private static final String KEY_ATTRIBUTE_NAME = "key";
    private static final int DEFAULT_SIZE = 10;
    private String m_uri;
    private int m_index;
    private String m_name;

    public HashMapperStringToComplex() {
        this.m_uri = null;
        this.m_index = 0;
        this.m_name = "hashmap";
    }

    public HashMapperStringToComplex(String uri, int index, String name) {
        this.m_uri = uri;
        this.m_index = index;
        this.m_name = name;
    }

    public boolean isExtension(int index) {
        return false;
    }

    public void marshal(Object obj, IMarshallingContext ictx) throws JiBXException {
        if (!(obj instanceof HashMap)) {
            throw new JiBXException("Invalid object type for marshaller");
        }
        if (!(ictx instanceof MarshallingContext)) {
            throw new JiBXException("Invalid object type for marshaller");
        }
        MarshallingContext ctx = (MarshallingContext)ictx;
        HashMap map = (HashMap)obj;
        ctx.startTagAttributes(this.m_index, this.m_name).attribute(this.m_index, SIZE_ATTRIBUTE_NAME, map.size()).closeStartContent();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ctx.startTagAttributes(this.m_index, ENTRY_ELEMENT_NAME);
            if (entry.getKey() != null) {
                ctx.attribute(this.m_index, KEY_ATTRIBUTE_NAME, entry.getKey().toString());
            }
            ctx.closeStartContent();
            if (entry.getValue() instanceof IMarshallable) {
                ((IMarshallable)entry.getValue()).marshal(ctx);
                ctx.endTag(this.m_index, ENTRY_ELEMENT_NAME);
                continue;
            }
            throw new JiBXException("Mapped value is not marshallable");
        }
        ctx.endTag(this.m_index, this.m_name);
    }

    public boolean isPresent(IUnmarshallingContext ctx) throws JiBXException {
        return ctx.isAt(this.m_uri, this.m_name);
    }

    public Object unmarshal(Object obj, IUnmarshallingContext ictx) throws JiBXException {
        UnmarshallingContext ctx = (UnmarshallingContext)ictx;
        if (!ctx.isAt(this.m_uri, this.m_name)) {
            ctx.throwStartTagNameError(this.m_uri, this.m_name);
        }
        int size = ctx.attributeInt(this.m_uri, SIZE_ATTRIBUTE_NAME, 10);
        HashMap<String, Object> map = (HashMap<String, Object>)obj;
        if (map == null) {
            map = new HashMap<String, Object>(size);
        }
        ctx.parsePastStartTag(this.m_uri, this.m_name);
        while (ctx.isAt(this.m_uri, ENTRY_ELEMENT_NAME)) {
            String key = ctx.attributeText(this.m_uri, KEY_ATTRIBUTE_NAME, null);
            ctx.parsePastStartTag(this.m_uri, ENTRY_ELEMENT_NAME);
            Object value = ctx.unmarshalElement();
            map.put(key, value);
            ctx.parsePastEndTag(this.m_uri, ENTRY_ELEMENT_NAME);
        }
        ctx.parsePastEndTag(this.m_uri, this.m_name);
        return map;
    }
}

