/*
 * $Revision: 1.6 $ $Date: 2005/04/11 16:33:29 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 * 쐬: 2004/05/15
 */
package feat.v1;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

import feat.v1.config.ConfigUtil;
import feat.v1.config.FeatConfig;
import feat.v1.config.FeatureConfig;
import feat.v1.config.FeatureDeclaration;
import feat.v1.config.FileLocator;
import feat.v1.config.ResourcesDeclaration;

public class ConfigReader {

    /**
     * feat-config.xmlǂݍށB
     * @param appRoot AvP[Ṽ[gfBNgB
     * @param locator feat-config.xmlt@CB
     * @throws FeatException
     * @return FeatConfig
     */
    public static FeatConfig parseFeatConfig(FileLocator appRoot, FileLocator locator) throws FeatException {

        FeatConfig config = null;

        InputStream in = null;
        try {
            // ݒt@C̓ǂݍ
            IBindingFactory bf = BindingDirectory.getFactory("featConfigBinding", FeatConfig.class);
            IUnmarshallingContext uctx = bf.createUnmarshallingContext();

            String encoding = ConfigUtil.getXMLEncoding(locator);
            if ( encoding == null )
                encoding = "utf-8";
            in = new BufferedInputStream(locator.openInputStream());
            config = (FeatConfig)uctx.unmarshalDocument(in, encoding);

            config.setAppRoot(appRoot);
            config.setConfigLocation(locator);

            // Featureݒt@C̓ǂݍ
            Iterator it = config.getFeatureConfigs();
            while( it.hasNext() ) {
                FeatureConfig fc = (FeatureConfig)it.next();
                FeatureDeclaration fd = ConfigReader.parseFeature(fc.getConfigFileLocation());
                fc.setFeatureDeclaration(fd);
                fd.setFeatureConfig(fc);
            }

            // 
            config.init();
        }
        catch (IOException ex) {
            throw new FeatException(ex, FeatException.LEVEL_FATAL);
        }
        catch (JiBXException ex) {
            throw new FeatException(ex, FeatException.LEVEL_FATAL);
        }
        finally {
            if ( in != null ) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                }
            }
        }
        return config;
    }

    /**
     * featureݒt@C̓ǂݍ݁B
     * @param config featureݒt@CB
     * @throws FeatException
     * @return FeatureDeclaration
     */
    public static FeatureDeclaration parseFeature(FileLocator file) throws FeatException {

        FeatureDeclaration featureDec = null;
        InputStream in = null;
        try {
            IBindingFactory bf = BindingDirectory.getFactory("featureConfigBinding", FeatureDeclaration.class);
            IUnmarshallingContext uctx = bf.createUnmarshallingContext();

            String encoding = ConfigUtil.getXMLEncoding(file);
            if ( encoding == null )
                encoding = "utf-8";
            in = new BufferedInputStream(file.openInputStream());
            featureDec = (FeatureDeclaration)uctx.unmarshalDocument(in, encoding);
        }
        catch (IOException ex) {
            throw new FeatException(ex, FeatException.LEVEL_FATAL);
        }
        catch (JiBXException ex) {
            throw new FeatException(ex, FeatException.LEVEL_FATAL);
        }
        finally {
            if ( in != null ) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                }
            }
        }

        return featureDec;
    }

    /**
     * \[Xt@CǂݍށB
     * @param file
     * @return
     * @throws FeatException ǂݍ݂Ɏs
     */
    public static ResourcesDeclaration parseResource(FileLocator file) throws FeatException {

	    ResourcesDeclaration resourcesDecl = null;
	    InputStream in = null;

	    try {
            IBindingFactory bf = BindingDirectory.getFactory("resourceBinding", ResourcesDeclaration.class);
            IUnmarshallingContext uctx = bf.createUnmarshallingContext();

            String encoding = ConfigUtil.getXMLEncoding(file);
            if ( encoding == null )
                encoding = "utf-8";
	        in = new BufferedInputStream(file.openInputStream());
	        resourcesDecl = (ResourcesDeclaration)uctx.unmarshalDocument(in, encoding);
	        resourcesDecl.init();
	    }
	    catch (IOException ex) {
	        throw new FeatException("IOException - "+file, ex, FeatException.LEVEL_ERROR);
	    }
        catch (JiBXException ex) {
	        throw new FeatException("JiBXException - "+file, ex, FeatException.LEVEL_ERROR);
        }
	    finally {
	        if ( in != null ) {
	            try {
	                in.close();
	            }
	            catch (IOException ex) {
	            }
	        }
	    }

	    return resourcesDecl;
    }
}
