/*
 * $Revision: 1.3 $ $Date: 2005/05/22 14:58:43 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 */

package feat.v1;

public class ResponsePointer {

    public static final String
            HOME_PAGE = "#home",
            CURRENT_PAGE = "#current";

    private String name;
    private String featureName;

    public ResponsePointer(String featureName, String name) {
        if ( featureName == null )
            throw new IllegalArgumentException("featureName == null");
        if ( name == null )
            throw new IllegalArgumentException("name == null");
        this.name = name;
        this.featureName = featureName;
    }

    public String getName() {
        return name;
    }

    public String getFeatureName() {
        return featureName;
    }

    public boolean equals(Object o) {
        ResponsePointer p = (ResponsePointer)o;
        return name.equals(p.name) && featureName.equals(p.featureName);
    }

    public String toString() {
        return featureName + "::" + name;
    }
}
