/*
 * $Revision: 1.3 $ $Date: 2005/05/04 15:13:07 $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬F 2004/4/4
 */

package feat.v1.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

/**
 * ClassLoaderŃ[hł郊\[Xt@C̈ʒu\邽߂̃NXB
 */
public class ClassLoaderFileLocator implements FileLocator {

    private ClassLoaderFileLocator root;
    private ClassLoader ctx;
    private URI path;

    /**
     *
     * @param path
     * @param ctx
     * @throws URISyntaxException pX̌`ɊԈႢ
     * @throws IllegalArgumentException null
     */
    public ClassLoaderFileLocator(String path, ClassLoader ctx) throws URISyntaxException, IllegalArgumentException {
        if ( path == null )
            throw new IllegalArgumentException("path:null");
        if ( ctx == null )
            throw new IllegalArgumentException("ctx:null");

        this.ctx = ctx;
        this.path = new URI(path);
        this.root = this;
    }

    private ClassLoaderFileLocator(URI path, ClassLoader ctx, ClassLoaderFileLocator root) {
        this.ctx = ctx;
        this.path = path;
        this.root = root;
    }

    /* ( Javadoc)
     * @see feat.v1.config.FileLocator#openInputStream()
     */
    public InputStream openInputStream() throws IOException {
        return ctx.getResourceAsStream(path.getPath());
    }

    /* ( Javadoc)
     * @see feat.v1.config.FileLocator#getURL()
     */
    public String getURL() throws MalformedURLException {
        URL url = getURL_();
        if ( url == null )
            return null;
        else
            return url.toExternalForm();
    }

    private URL getURL_() throws MalformedURLException {
        String name = path.getPath();
        return ctx.getResource(name);
    }

    /* ( Javadoc)
     * @see feat.v1.config.FileLocator#getURIString()
     */
    public String getURIString() {
        try {
            return getURL();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /* ( Javadoc)
     * @see feat.v1.config.FileLocator#exists()
     */
    public boolean exists() {
        try {
            return getURL_() != null;
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /* ( Javadoc)
     * @see feat.v1.config.FileLocator#getFilename()
     */
    public String getFilename() {
        String pathstr = path.getPath();

        // Ōオ'/'fBNg
        if ( pathstr.endsWith("/") ) {
            return null;
        }

        // Ō'/'ȍ~̖Ot@C
        int slashIndex = pathstr.lastIndexOf('/');
        if ( slashIndex == -1 )
            return pathstr;
        else
            return pathstr.substring(slashIndex+1);
    }

    /**
     * ̃\bh͏0ԂB
     * @see FileLocator#getLastModified()
     */
    public long getLastModified() throws IOException {
        return 0L;
    }

    /* ( Javadoc)
     * @see feat.v1.config.FileLocator#newLocation(java.lang.String)
     */
    public FileLocator newLocation(String relativePath) throws IllegalArgumentException {
        if ( relativePath != null ) {
            if ( relativePath.startsWith("/") )
                throw new IllegalArgumentException("\""+relativePath+"\" '/'Ŏn܂pX͎włȂ");
            if ( relativePath.startsWith(".") )
                throw new IllegalArgumentException("\""+relativePath+"\" fBNg̐擪'.'͎gpłȂ");
            if ( relativePath.indexOf("..") > -1 )
                throw new IllegalArgumentException("\""+relativePath+"\" ʂ̃fBNg͎włȂ");

            //URI current = new URI(path.toExternalForm());
            URI newUri = path.resolve(relativePath);
            return new ClassLoaderFileLocator(newUri, ctx, root);
        }
        else
            return this;
    }

    /* ( Javadoc)
     * @see feat.v1.config.FileLocator#rootLocation()
     */
    public FileLocator rootLocation() {
        return root;
    }

    public String toString() {
        return path.getPath();
    }

    public boolean equals(Object o) {
        ClassLoaderFileLocator loc = (ClassLoaderFileLocator)o;
        boolean ret = path.getPath().equals(loc.path.getPath());
        if ( root != this )
            ret = ret && root.equals(loc.root);
        return ret;
    }
}
