/*
 * $Id: RedirectResponse.java,v 1.1 2005/04/17 16:43:03 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/04/18
 */
package feat.v1.config;

import java.io.IOException;

import javax.servlet.ServletException;

import feat.v1.ContextAccessor;
import feat.v1.Response;

/**
 * @author SUGIMOTO Ken-ichi
 */
public class RedirectResponse implements Response {

    private RedirectDeclaration decl;

    public RedirectResponse(RedirectDeclaration declaration) {
        this.decl = declaration;
    }

    public void output(ContextAccessor acc) throws ServletException {
        try {
            acc.getResponse().sendRedirect(decl.getUri());
        }
        catch (IOException ex) {
            throw new ServletException(ex);
        }
    }

}
