/*
 * $Revision: 1.5 $ $Date: 2005/12/17 16:22:27 $
 * (C) 2005 SUGIMOTO Ken-ichi
 * 쐬F 2005/7/21
 */

package feat.v1.impl.template;

import feat.v1.StringUtil;
import feat.v1.template.HTMLNode;
import feat.v1.template.HTMLText;
import feat.v1.template.NodeNotFoundException;

/**
 * eLXgm[h\NXB
 */
public class HTMLTextImpl extends HTMLNodeImpl implements HTMLText {

    private String text;

    /**
     * ̃eLXgm[h쐬B
     */
    HTMLTextImpl() {
        this(null);
    }

    /**
     * ew肵ăeLXgm[h쐬B
     * @param rawText m[h̓eBGXP[vȂB
     */
    public HTMLTextImpl(String rawText) {
        setRawText(rawText);
        setDomNode(new DOMTextImpl(this));
    }

    public void setText(String text) {
        if ( text != null )
            setRawText(StringUtil.escapeHTMLText(text));
        else
            setRawText(null);
    }

    public void setRawText(String str) {
        text = str;
    }

    public String getText() {
        if ( text == null )
            return null;
        else
            return StringUtil.unescapeHTMLText(text);
    }

    public void addText(String text) {
        addRawText(text == null ? null : StringUtil.escapeHTMLText(text));
    }

    public void addRawText(String str) {
        if ( str != null ) {
            if ( text == null )
                text = str;
            else
                text += str;
        }
    }

    public String toString() {
        if ( text != null )
            return StringUtil.unescapeHTMLText(text);
        else
            return "";
    }

    // HTMLNode̎ -----------------------------------------------------------

    public String getValue() {
        return getText();
    }

    public HTMLNode copy(boolean deep) {
        HTMLText ret = new HTMLTextImpl();
        ret.setRawText(text);
        return ret;
    }

    public StringBuffer toHTML(StringBuffer buf) {
        if ( text != null )
            buf.append(text);
        return buf;
    }

    public int getNodeType() {
        return NODETYPE_TEXT;
    }

    public HTMLNode getFirstChild() throws NodeNotFoundException {
        throw new NodeNotFoundException();
    }

    public void setFirstChild(HTMLNode child) {
    }

}
