/*
 * $Id: Option.java,v 1.1 2005/12/18 03:26:21 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/12/08
 */
package feat.v1.template.form;

import feat.v1.template.HTMLElement;
import feat.v1.template.NodeFactory;

/**
 * Xg̑IB
 * @author SUGIMOTO Ken-ichi
 */
public class Option implements ListItem {

    private HTMLElement element;

    public Option(String name, String value) {
        element = NodeFactory.createHTMLElement("option", true);
        element.setText(name);
        element.setAttribute("value", value);
    }

    public Option(HTMLElement element) {
        this.element = element;
    }

    public String getLabel() {
        return element.getAttribute("label");
    }

    /**
     * labelݒ肷Boptionvf̓e͕ύXȂB
     * optionvf̓esetContentŐݒ肷B
     * @param label
     */
    public void setLabel(String label) {
        if ( label == null )
            element.removeAttribute("label");
        else
            element.setAttribute("label", label);
    }

    /**
     * lԂBAvalueݒ肳ĂȂΗvf̓eԂB
     * @return
     */
    public String getValue() {
        String value = element.getAttribute("value");
        if ( value == null )
            return getContent();
        else
            return value;

    }

    public void setValue(String value) {
        if ( value == null )
            element.removeAttribute("value");
        else
            element.setAttribute("value", value);
    }

    public boolean isSelected() {
        return element.hasAttribute("selected");
    }

    public void setSelected(boolean selected) {
        if ( selected )
            element.setAttribute("selected", null);
        else
            element.removeAttribute("selected");
    }

    public String getContent() {
        return element.getString();
    }

    public void setContent(String value) {
        element.setText(value);
    }

    public HTMLElement getElement() {
        return element;
    }


}
