/*
 * $Revision: 1.8 $ $Date: 2005/11/03 09:41:48 $
 * (C) 2004 SUGIMOTO Ken-ichi
 * 쐬F 2004/10/3
 */

package feat.v1.view;

import java.util.Iterator;

import feat.v1.ContextAccessor;
import feat.v1.FeatureError;
import feat.v1.FeatureErrors;
import feat.v1.View;
import feat.v1.template.HTMLDocument;
import feat.v1.template.HTMLElement;
import feat.v1.template.NodeFactory;
import feat.v1.template.NodeNotFoundException;

/**
 * ev[g\邾̃r[B
 * p[^Ƀ^OIDw肷ƁAG[Xgo͂łB
 */
public class ErrorListView extends View {

    //private String errorTag;

    public ErrorListView() {
        //errorTag = "errorlist";
    }

    /*public ErrorListView(String errorTag) {
        this.errorTag = errorTag;
    }*/

    public HTMLDocument format(HTMLDocument template, String[] params, ContextAccessor acc) throws NodeNotFoundException {
        FeatureErrors errs = acc.getFeatureErrors();
        String errorTagId = "errorlist";
        if ( params.length >= 1 )
            errorTagId = params[0];

        // G[Xgo͂
        HTMLElement errorlist = template.findElement(errorTagId);
        if ( errs.count() == 0 ) {
            errorlist.detach();
        } else {
            errorlist.clear();
            for(Iterator it = errs.iterator(); it.hasNext(); ) {
                FeatureError err = (FeatureError)it.next();
                errorlist.addText(err.getMessage());
                errorlist.addChild(NodeFactory.createHTMLElement("br", false));
                errorlist.addText("\n");
            }
        }

        return template;
    }
}
