/*
Copyright (c) 2002-2004, Dennis M. Sosnoski.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
 * Neither the name of JiBX nor the names of its contributors may be used
   to endorse or promote products derived from this software without specific
   prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package org.jibx.runtime;

/**
 * Binding factory interface definition. This interface is implemented by
 * the binding factory class generated by each binding definition.
 *
 * @author Dennis M. Sosnoski
 * @version 1.0
 */

public interface IBindingFactory
{
    /** Current binary version number. This is a byte-ordered value, allowing
     for two levels of major and two levels of minor version. */
    public static final int CURRENT_VERSION_NUMBER = 0x00000000;
    
    /** Current distribution file name. This is filled in by the Ant build
     process to match the current distribution. */
    public static final String CURRENT_VERSION_NAME = "jibx-beta3c";
    
    /** Mask for portions of version number that effect compatibility. */
    public static final int COMPATIBLE_VERSION_MASK = 0xFFFF0000;
    
    /**
     * Create marshalling context instance.
     *
     * @return created marshalling context instance
     * @throws JiBXException if error creating context
     * @throws UnsupportedOperationException if marshalling not supported
     * by binding
     */
     
    public IMarshallingContext createMarshallingContext()
        throws JiBXException;
    
    /**
     * Create unmarshalling context instance.
     *
     * @return created unmarshalling context instance
     * @throws JiBXException if error creating context
     * @throws UnsupportedOperationException if unmarshalling not supported
     * by binding
     */
     
    public IUnmarshallingContext createUnmarshallingContext()
        throws JiBXException;
    
    /**
     * Get version number for binding compiler used.
     *
     * @return version number of code used to compile binding
     */
     
    public int getCompilerVersion();
    
    /**
     * Get distribution name for binding compiler used.
     *
     * @return name of distribution for binding compiler
     */
     
    public String getCompilerDistribution();
    
    /**
     * Get namespaces defined in mapping. The returned array is indexed by the
     * namespace index number used when marshalling.
     *
     * @return array of namespaces defined in binding (<code>null</code> if not
     * an output binding)
     */
     
    public String[] getNamespaces();
    
    /**
     * Get mapped class names. Returns array of fully-qualified class names,
     * ordered by index number of the class.
     *
     * @return array of class names
     */
     
    public String[] getMappedClasses();
    
    /**
     * Get namespaces of elements corresponding to mapped classes. The returned
     * array uses the same ordering as the result of the {@link
     * #getMappedClasses} call. Entries in the array are <code>null</code> if
     * there is no element for a class or the element is in the default
     * namespace.
     *
     * @return array of element namespaces
     */
     
    public String[] getElementNamespaces();
    
    /**
     * Get names of elements corresponding to mapped classes. The returned array
     * uses the same ordering as the result of the {@link #getMappedClasses}
     * call. Entries in the array are <code>null</code> if there is no element
     * for a class.
     *
     * @return array of element names
     */
     
    public String[] getElementNames();
}
