import java.io.File;
import java.util.Locale;

import feat.v1.ConfigReader;
import feat.v1.FeatTask;
import feat.v1.TemplateLoader;
import feat.v1.config.BasicFileLocator;
import feat.v1.config.FeatConfig;
import feat.v1.config.FeatureConfig;
import feat.v1.config.FeatureDeclaration;
import feat.v1.config.FileLocator;
import feat.v1.config.PageDeclaration;
import feat.v1.config.ResponseDeclaration;
import feat.v1.template.HTMLDocument;
import feat.v1.template.HTMLTemplate;

public class Main {
    public static void main(String[] args) {
        Main m = new Main();

        try {
            m.loadConfig();
            //m.executeTask();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadConfig() throws Exception {
        FileLocator config = new BasicFileLocator(new File("web/WEB-INF/feat-config.xml"));
        FileLocator app = new BasicFileLocator(new File("web"));
        FeatConfig conf = ConfigReader.parseFeatConfig(app, config);
        conf.validate();
        FeatureDeclaration feature = conf.getFeatureDeclaration("login");
        FeatureConfig featureConf = feature.getFeatureConfig();
        System.out.println("resource:"+featureConf.getFeatureDeclaration().getStringResource("error.auth", null));
        ResponseDeclaration responseDec = feature.getResponseDeclaration("index");
        if ( responseDec instanceof PageDeclaration ) {
            PageDeclaration pageDecl = (PageDeclaration)responseDec;
            FileLocator file = featureConf.getTemplateLocation().newLocation(pageDecl.getTemplateName());
            HTMLTemplate template = TemplateLoader.load(file, new Locale("ja", "JP"), null);
            HTMLDocument doc = template.getDocument();
        }

    }

    public void executeTask() {
        FeatTask task = new FeatTask();
        task.setAppdir(new File("web"));
        task.setDestdir(new File("gensrc"));
        task.execute();
    }
}
