/*
 * $Id: StringUtil.java,v 1.6 2005/11/27 23:41:24 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/04/17
 */
package feat.v1;


import java.util.Locale;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;


/**
 * 񑀍̃[eBeB\bhW߂NXB
 * @author SUGIMOTO Ken-ichi
 */
public class StringUtil {

    /**
     * zCgXy[XEƂĕB
     * @param str
     * @return
     */
    public static String[] split(String str) {
        return StringUtils.split(str);
    }

    public static String[] split(String str, String delimitor) {
        return StringUtils.split(str, delimitor);
    }

    public static String[] split(String str, char delim) {
        return StringUtils.split(str, delim);
    }

    public static String join(String[] array, String str) {
        return StringUtils.join(array, str);
    }

    public static String[] stripAll(String[] str) {
        return StringUtils.stripAll(str);
    }

    public static String substringBefore(String str, String separator) {
        return StringUtils.substringBefore(str, separator);
    }

    /**
     * 󔒂ŋ؂ꂽP̐擪̕啶ɂB
     * @param str
     * @return
     */
    public static String capitalize(String str) {
        return WordUtils.capitalize(str);
    }

    public static String escapeHTMLText(String str) {
        str = StringUtils.replace(str, "&", "&amp;");
        str = StringUtils.replace(str, "<", "&lt;");
        str = StringUtils.replace(str, ">", "&gt;");
        str = StringUtils.replace(str, "\"", "&quot;");
        return str;
    }

    public static String unescapeHTMLText(String escaped) {
        escaped = StringUtils.replace(escaped, "&lt;", "<");
        escaped = StringUtils.replace(escaped, "&gt;", ">");
        escaped = StringUtils.replace(escaped, "&quot;", "\"");
        escaped = StringUtils.replace(escaped, "&amp;", "&");
        return escaped;
    }

    public static String replace(String str, String o, String n) {
        return StringUtils.replace(str, o, n);
    }

    public static String replaceParameters(String str, String[] values) {
        String[] names = new String[values.length];
        for(int i=0; i<names.length; i++) {
            names[i] = Integer.toString(i+1);
        }
        return replaceParameters(str, names, values);
    }

    public static String replaceParameters(String str, String[] names, String[] values) {
        char[] c = str.toCharArray();
        StringBuffer buf = new StringBuffer(c.length * 6 / 5);
        StringBuffer name = new StringBuffer();
        int mode = 0;
        for(int idx=0; idx<c.length; idx++) {
            switch(mode) {
                // '$'T
                case 0:
                    if ( c[idx] == '$' )
                        mode = 1;
                    else
                        buf.append(c[idx]);
                    break;
                // '$'̎̕
                case 1:
                    if ( c[idx] == '$' ) {
                        buf.append('$');
                        mode = 0;
                    }
                    else if ( c[idx] == '{' ) {
                        mode = 2;
                        name.setLength(0);
                    }
                    break;
                // p[^
                case 2:
                    if ( c[idx] == '}' ) {
                        mode = 0;
                        String n = name.toString();
                        for(int i=0; i<names.length; i++) {
                            if ( names[i].equals(n) ) {
                                buf.append(values[i]);
                            }
                        }
                    }
                    else {
                        name.append(c[idx]);
                    }
                    break;
            }
        }
        return buf.toString();
    }

    /**
     * P[܂񂾃t@CB
     * ̃t@C̊gq̑OɎw̃P[}B
     * gqƂ݂Ȃ̂̓t@C̍Ō'.'̌B
     * gqQȏdȂĂ".tar.gz"̂悤ȃt@C".tar.ja.gz"ƂȂĂ܂̂ŒӁB
     * @param baseName ɂȂt@C
     * @param locale P[
     * @return
     */
    public static String makeLocaleFilename(String baseName, Locale locale) {
        if ( locale != null && !locale.equals(Util.NULL_LOCALE) ) {
            int dotIdx = baseName.lastIndexOf('.');
            String ret = baseName.substring(0, dotIdx) + "." + locale.toString() + baseName.substring(dotIdx);
            return ret;
        }
        else
            return baseName;
    }
}
