/*
 * $Id: Util.java,v 1.12 2005/12/25 23:36:16 sugimotokenichi Exp $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 */

package feat.v1;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.apache.commons.lang.StringUtils;

import feat.v1.config.Function;


public class Util {

    /*public static String getAttribute(NamedNodeMap map, String name, String defaultValue)
            throws FeatException {
        Attr attr = (Attr)map.getNamedItem(name);
        String ret = null;
        if ( attr == null ) {
            if ( defaultValue == null )
                throw new FeatException(name + " == null");
            ret = defaultValue;
        }
        else
            ret = attr.getValue();
        return ret;
    }*/

    public static Throwable getRootCause(Throwable t) {
        while(t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static final Locale NULL_LOCALE = new Locale("");

    /**
     * \[XoȟV[PX𐶐B
     * @param locale
     * @return
     */
    public static List makeSequence(Locale locale) {
        ArrayList list = new ArrayList(3);
        if ( locale != null && !locale.equals(NULL_LOCALE) ) {
            String v = locale.getVariant();
            int vl = v.length();
            String c = locale.getCountry();
            int cl = c.length();
            String l = locale.getLanguage();
            int ll = l.length();
            if ( vl > 0 ) {
                list.add(new Locale(l, c, v));
            }
            if ( cl > 0 ) {
                list.add(new Locale(l, c));
            }
            if ( ll > 0 ) {
                list.add(new Locale(l));
            }
        }
        return list;
    }

    /**
     * P[P[IuWFNgɕϊB
     * @param localeString
     * @return nꂽ񂪋󕶎܂null̂ƂnullԂ
     */
    public static Locale parseLocale(String localeString) {
        if ( localeString == null || localeString.length() == 0 )
            return null;

        String[] elem = StringUtils.split(localeString, '_');
        Locale ret = null;
        if ( elem.length == 1 )
            ret = new Locale(elem[0]);
        else if ( elem.length == 2 )
            ret = new Locale(elem[0], elem[1]);
        else if ( elem.length == 3 )
            ret = new Locale(elem[0], elem[1], elem[2]);
        return ret;
    }

    /**
     * ","؂̃Xgp[XB
     * ()̒','͋؂LƂȂB
     * @param list Xg̕
     * @return vfƂ͒O̔z
     */
    public static String[] parseList(String list) {
        int len = list.length();
        int mode = MODE_INIT;
        StringBuffer buf = new StringBuffer(16);
        ArrayList ret = new ArrayList();
        int i = 0;
        while ( i < len ) {
            char ch = list.charAt(i++);
            switch(mode) {
                case MODE_INIT:
                    if ( !Character.isWhitespace(ch) ) {
                        mode = MODE_READ;
                        buf.append(ch);
                    }
                    break;

                case MODE_READ:
                    if ( ch == ',') {
                        // ','ɑ烊Xglo
                        String val = buf.toString().trim();
                        if ( val != null && val.length() > 0 )
                            ret.add(val);
                        buf.setLength(0);
                        mode = MODE_INIT;
                    }
                    else {
                        // '('p[^ǂݎ胂[h
                        if ( ch == '(' ) {
                            mode = MODE_FUNCTION_PARAM;
                        }
                        buf.append(ch);
                    }
                    break;

                case MODE_FUNCTION_PARAM:
                    if ( ch == ')' ) {
                        // ')'ʏ̓ǂݎ胂[h֖߂
                        mode = MODE_READ;
                    }
                    buf.append(ch);
                    break;

            }
        }

        // Ō̗vfcĂǉ
        if ( buf.length() > 0 ) {
            String val = buf.toString().trim();
            if ( val != null && val.length() > 0 )
                ret.add(val);
        }

        return (String[])ret.toArray(new String[ret.size()]);
    }
    private static final int
	MODE_INIT = 0,
	MODE_READ = 1,
	MODE_FUNCTION_PARAM = 2;

    /**
     * ֐`̕܂񂾃Xgp[XB
     * ֐́A֐(1, 2, ... ) ̌`B
     * OAƂŐ󔒕͍폜B
     * @param liststr ֐Xg`̕
     * @return vfƂ͒O̔z
     * @see Character#isWhitespace(char)
     */
    public static Function[] parseFunctionList(String liststr) {
        String[] list = parseList(liststr);
        Function[] ret = new Function[list.length];
        for(int i=0; i<list.length; i++) {
            ret[i] = new Function(list[i]);
        }
        return ret;
    }

    /**
     * X|X͂B
     * @param responseName X|XB"tB[`[::X|X"̌`B
     *         tB[`[ȗ"X|X"̌`󂯓
     * @param featureName responseNameŃtB[`[ȗꂽƂ̃tB[`[
     * @return
     */
    public static ResponsePointer parseResponseName(String responseName, String featureName) {
        ResponsePointer pointer = null;
        if ( responseName.indexOf("::") > -1) {
            String[] elem = StringUtil.split(responseName, "::");
            pointer = new ResponsePointer(elem[0], elem[1]);
        }
        else {
            pointer = new ResponsePointer(featureName, responseName);
        }
        return pointer;
    }

}
