/*
 * $Id: ConfigUtil.java,v 1.2 2005/05/22 14:58:43 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/04/10
 */
package feat.v1.config;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;

import feat.v1.InitializationException;

/**
 * ݒt@CɊ֘A[eBeB
 * @author SUGIMOTO Ken-ichi
 */
public class ConfigUtil {

    public static void init(List c) throws InitializationException {
        for(int i=0; i<c.size(); i++) {
            ConfigElement e = (ConfigElement)c.get(i);
            if ( e != null )
                e.init();
        }
    }

    public static void validate(List c) throws InitializationException {
        for(int i=0; i<c.size(); i++) {
            ConfigElement e = (ConfigElement)c.get(i);
            if ( e != null )
                e.validate();
        }
    }

    /**
     * Xg̒疼OnamẽIuWFNgTB
     * @param c
     * @param name
     * @return IuWFNgBȂnullB
     */
    public static ConfigElement find(List c, String name) {
        if ( name == null || c == null )
            return null;

        for(int i=0; i<c.size(); i++) {
            ConfigElement e = (ConfigElement)c.get(i);
            if ( e != null && e.getName().equals(name) )
                return e;
        }

        return null;
    }

    public static String getXMLEncoding(FileLocator file) {
        //System.out.println(file.toString());
        BufferedInputStream in = null;
        try {
	        in = new BufferedInputStream(file.openInputStream());
	        int mode = 0;
	        String attributeName = null;
	        while(true) {
	            switch( mode ) {

	                // "<?xml"
	                case 0: {
	                    skip('<', true, in);
	                    if ( read("?xml", in) )
	                        mode = 1;
	                    break;
	                }

                    // ǂݎ
                	case 1:
	                    attributeName = null;
                	    if ( !readWhitespace(in) )
                	        mode = 0;
                	    if ( read("encoding", in) ) {
                	        attributeName = "encoding";
                	        mode = 2;
                	    }
                	    else if ( read("version", in) ) {
                	        attributeName = "version";
                	        mode = 2;
                	    }
                	    else if ( read("standalone", in) ) {
                	        attributeName = "standalone";
                	        mode = 2;
                	    }
                	    else
                	        return null;
                	    break;

            	    // lǂݎ
                	case 2: {
                	    readWhitespace(in);
                	    if ( read("=", in) ) {
                	        readWhitespace(in);
                	        // ""̒ǂݎ
                	        String value = null;
                	        if ( read("\"", in) ) {
                	            value = skip('"', false, in);
                	        }
                	        else if ( read("'", in) ) {
                	            value = skip('\'', false, in);
                	        }
                	        //System.out.println(attributeName+"="+value);
            	            if ( attributeName.equals("encoding") && value != null ) {
            	                return value;
            	            }
                	    }
                	    mode = 1;
                	    break;
                	}
	            }
	        }
        }
        catch (IOException ex) {
            return null;
        }
        finally {
            if ( in != null )
                try {
                    in.close();
                }
            catch (IOException ex) {}
        }
    }

    /**
     * w̕܂ŃXg[當ǂށB
     * @param tail
     * @param discard ǂݎԂɎ̂ĂȂtrue
     * @param in
     * @return tail܂łɓǂݎBtail͊܂܂Ȃ
     * @throws IOException
     * @throws EOFException tailOɃXg[̍ŌɓB
     */
    private static String skip(char tail, boolean discard, BufferedInputStream in) throws IOException, EOFException {
        StringBuffer buf = discard ? null : new StringBuffer();
        in.mark(256);
        int c;
        do {
            c = in.read();
            if ( c == -1 ) {
                in.reset();
                throw new EOFException();
            }
            else if ( c != tail && buf != null ) {
                buf.append((char)c);
            }
        }
        while ( c != tail );

        if ( buf != null ) {
            return buf.toString();
        }
        else
        	return null;
    }

    /**
     * Xg[當ǂݎB
     * Xg[݂̌̈ʒuɎw̕񂩂疳A
     * ǂݎʒũ\bh̊Jn_ɖ߂B
     * @param string
     * @param in
     * @return
     * @throws IOException
     */
    private static boolean read(String string, BufferedInputStream in) throws IOException {
        char[] cstr = string.toLowerCase().toCharArray();
        in.mark(cstr.length);
        for(int idx=0; idx < cstr.length; idx++) {
            int c = in.read();

            // Ō܂œǂł܂false
            if ( c == -1 ) {
                in.reset();
                return false;
            }

            // PǂŔr
            char ch = Character.toLowerCase((char)c);
            if ( ch != cstr[idx] ) {
                in.reset();
                return false;
            }
        }

        return true;
    }

    /**
     * 󔒕ǂݎBXg[݂̌̈ʒu͋󔒕̎̕ɃZbgB
     * @param in
     * @return 󔒕trueBfalseB
     * @throws IOException
     */
    private static boolean readWhitespace(BufferedInputStream in) throws IOException {
        boolean ret = false;
        while( true ) {
    	    in.mark(16);
            char c = (char)in.read();
            if ( Character.isWhitespace(c) ) {
                ret = true;
            }
            else {
                in.reset();
                return ret;
            }
        }
    }


}
