/*
 * $Id: Function.java,v 1.5 2005/12/25 23:36:16 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/03/23
 */
package feat.v1.config;

import feat.v1.StringUtil;

/**
 * ֐̖Oƃp[^B
 * @author SUGIMOTO Ken-ichi
 */
public class Function {

	private String name;
	private String[] params;

    public Function(String name, String[] params) {
        this.name = name;
        this.params = params;
    }

    /**
     * ֐`̕p[XB
     *  ֐(1, 2, ... ) ̌`B
     * OAƂŐ󔒕͍폜B
     * @param func ֐`̕
     * @see Character#isWhitespace(char)
     */
    public Function(String func) {
        int leftBracketIndex = func.indexOf('(');
        // ֐
        if ( leftBracketIndex == -1 ) {
            name = func.trim();
        }
        else if ( leftBracketIndex > 0 ) {
            name = func.substring(0, leftBracketIndex).trim();
        }

        // Xg
        if ( leftBracketIndex > -1 ) {
            int rightBracketIndex = func.indexOf(')', leftBracketIndex+1);
            String pstr = func.substring(leftBracketIndex+1, rightBracketIndex);
            params = StringUtil.stripAll(StringUtil.split(pstr, ','));
        }
        else {
            params = new String[0];
        }
    }

    /**
     * @return name ߂܂B
     */
    public String getName() {
        return name;
    }
    /**
     * @return params ߂܂B
     */
    public String[] getParams() {
        return params;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("name:").append(name);
        buf.append(" params:[").append(StringUtil.join(params, ",")).append("]");
        return buf.toString();
    }
}
