/*
 * $Revision: 1.6 $ $Date: 2005/04/17 03:31:46 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 */

package feat.v1.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.IUnmarshallingContext;

import feat.v1.InitializationException;
import feat.v1.StringUtil;
import feat.v1.Util;

/**
 * HTML\r[̐ݒB
 */
public class PageDeclaration implements ResponseDeclaration {

    private static Log log = LogFactory.getLog(PageDeclaration.class);

    private FeatureDeclaration featureDeclaration;

    // init()ŏvpeB
    //private HTMLTemplate template;
    private ViewDeclaration[] viewList;
    private Function[] viewParams;

    // JiBX
    private String name;
    private String templateFileName;
    private String view;


    public PageDeclaration() {
    }

    public String getName() {
        return name;
    }

    public String getTemplateName() {
        return templateFileName;
    }

    public ViewDeclaration[] getViewList() {
        return viewList;
    }

    public Function[] getViewParams() {
        return viewParams;
    }



    public FeatureDeclaration getFeatureDeclaration() {
        return featureDeclaration;
    }
    /*public void setFeatureDeclaration(FeatureDeclaration f) {
        featureDeclaration = f;
    }*/

    public void postset(IUnmarshallingContext uctx) {
        featureDeclaration = (FeatureDeclaration)uctx.getStackObject(1);
    }

    public void init() throws InitializationException {
        FeatConfig conf = getFeatureDeclaration().getFeatureConfig().getFeatConfig();

        if ( templateFileName == null )
            throw new InitializationException("ev[gw肳ĂȂ");
        if ( view == null )
            view = "";

        //template = TemplateLoader.load(((FeatureConfig)getAncestorElement(FEATURE_CONFIG)).
        //                        getTemplateLocation().newLocation(templateFileName));

        // view̃Xg
        if ( view.length() > 0 ) {
            viewParams = Util.parseFunctionList(view);
            viewList = new ViewDeclaration[viewParams.length];

            for(int i=0; i<viewParams.length; i++) {
                FeatureDeclaration featureDec;
                String viewName = viewParams[i].getName();

                // ق̃tB[`[̃r[?
                if ( viewName.indexOf("::") > -1 ) {

                    // tB[`[ƃr[̖Oɕ
                    String[] pathElem = StringUtil.split(viewName, "::");
                    if ( pathElem.length < 2 )
                        throw new InitializationException("r[̎w肪sS \""+viewName+"\"");
                    String featureName = pathElem[0];

                    // tB[`[̒`擾
                    featureDec = conf.getFeatureDeclaration(featureName);
                    viewName = pathElem[1];
                    if ( featureDec == null )
                        throw new InitializationException(
                                "w肳ꂽr["+viewParams[i].getName()+
                                "̃tB[`[ "+featureName+"Ȃ");

                }
                // ݂̃tB[`[̃r[̏ꍇ
                else {
                    featureDec = getFeatureDeclaration();
                }

                // r[̒`擾
                viewList[i] = featureDec.getView(viewName);
                if ( viewList[i] == null )
                    throw new InitializationException(
                            "w肳ꂽr[ "+viewParams[i].getName()+" Ȃ");
            }
        }
        // r[̃XĝƂ
        else {
            viewList = new ViewDeclaration[0];
            viewParams = new Function[0];
        }

    }

    public void validate() {}
}
