/*
 * $Id: DOMCharacterDataImpl.java,v 1.1 2005/11/03 09:41:47 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/10/30
 */
package feat.v1.impl.template;

import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;

/**
 * DOM APICharacterData̎B
 * @author SUGIMOTO Ken-ichi
 */
abstract public class DOMCharacterDataImpl extends DOMNodeImpl implements CharacterData {

    DOMCharacterDataImpl(HTMLNodeImpl htmlNode) {
        super(htmlNode);
    }

    // Node̎

    public short getNodeType() {
        return COMMENT_NODE;
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getNodeValue() throws DOMException {
        return convertHTML().getValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
    }

    public NamedNodeMap getAttributes() {
        return new HTMLNodeMapImpl();
    }


    // CharacterData̎

    public void appendData(String arg) throws DOMException {
        throw new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
    }

    public void deleteData(int offset, int count) throws DOMException {
        throw new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
    }

    public String getData() throws DOMException {
        return convertHTML().getValue();
    }

    public int getLength() {
        return convertHTML().getValue().length();
    }

    public void insertData(int offset, String arg) throws DOMException {
        throw new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
    }

    public void replaceData(int offset, int count, String arg)
            throws DOMException {
        throw new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
    }

    public void setData(String data) throws DOMException {
        throw new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
    }

    public String substringData(int offset, int count) throws DOMException {
        return convertHTML().getValue().substring(offset, offset+count);
    }

}

