/*
 * $Id: DOMDocumentImpl.java,v 1.1 2005/11/03 09:41:47 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/10/30
 */
package feat.v1.impl.template;

import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

import feat.v1.template.NodeNotFoundException;
import feat.v1.template.NodeSelector;
import feat.v1.template.NodeTreeIterator;

/**
 * DOM APIDocument̎B
 * @author SUGIMOTO Ken-ichi
 */
public class DOMDocumentImpl extends DOMNodeImpl implements Document {

    DOMDocumentImpl(HTMLElementImpl htmlNode) {
        super(htmlNode);
    }

    private HTMLElementImpl getHTMLElement() {
        return (HTMLElementImpl)convertHTML();
    }

    // Node̎

    public NamedNodeMap getAttributes() {
        return new HTMLNodeMapImpl();
    }

    public String getLocalName() {
        return null;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    // Document̎

    public short getNodeType() {
        return Node.DOCUMENT_NODE;
    }

    public String getNodeName() {
        return "#document";
    }

    public DOMImplementation getImplementation() {
        return null;
    }

    public DocumentFragment createDocumentFragment() {
        return null;
    }

    public DocumentType getDoctype() {
        return null;
    }

    public Element getDocumentElement() {
        try {
            return (Element)TemplateUtil.toDomNode(getHTMLElement().getTag("html"));
        }
        catch (NodeNotFoundException ex) {
            return null;
        }
    }

    public Attr createAttribute(String name) throws DOMException {
        return null;
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return null;
    }

    public Comment createComment(String data) {
        return null;
    }

    public Element createElement(String tagName) throws DOMException {
        return null;
    }

    public Element getElementById(String elementId) {
        try {
            return (Element)TemplateUtil.toDomNode(getHTMLElement().findElement(elementId));
        }
        catch (NodeNotFoundException ex) {
            return null;
        }
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return null;
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagName(String name) {
        return TemplateUtil.toDomNodeList(NodeSelector.selectTags(new NodeTreeIterator(convertHTML()), name));
    }

    public Text createTextNode(String data) {
        return null;
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if ( namespaceURI == null ) {
            return getElementsByTagName(localName);
        }
        else {
            return new HTMLNodeListImpl();
        }
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return null;
    }

}
