/*
 * $Revision: 1.4 $ $Date: 2005/12/17 16:22:27 $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬F 2005/7/29
 */

package feat.v1.impl.template;

import feat.v1.FeatRuntimeException;
import feat.v1.StringUtil;
import feat.v1.template.HTMLNode;
import feat.v1.template.HTMLRemark;
import feat.v1.template.NodeNotFoundException;
import feat.v1.template.RemarkTextException;

/**
 * Rg\NXB
 */
public class HTMLRemarkImpl extends HTMLNodeImpl implements HTMLRemark {

    private String text;

    /**
     * ̃Rgm[h쐬B
     */
    HTMLRemarkImpl() {
        setDomNode(new DOMCommentImpl(this));
    }

    /**
     * ew肵ăRgm[h쐬B
     * @param str "&lt;!--", "--&gt;"܂܂ȂRg̓ẽeLXgB
     * @throws RemarkTextException eLXg̒"--"܂܂Ă
     */
    HTMLRemarkImpl(String str) throws RemarkTextException {
        this();
        if ( str != null ) {
            if ( str.indexOf("--") > -1 ) {
                throw new RemarkTextException();
            }
            this.text = str;
        }
    }

    public void setText(String str) throws RemarkTextException {
        if ( str != null ) {
            if ( str.indexOf("--") > -1 ) {
                throw new RemarkTextException();
            }
            this.text = str;
        }
        else
            this.text = null;
    }

    public String getText() {
        return text;
    }

    public void addText(String str) throws RemarkTextException {
        if ( str != null ) {
            if ( str.indexOf("--") > -1 ) {
                throw new RemarkTextException();
            }
            this.text += str;
        }
    }

    public String toString() {
        if ( text != null )
            return StringUtil.unescapeHTMLText(text);
        else
            return "";
    }

    // HTMLNode̎ -----------------------------------------------------------

    public String getValue() {
        return getText();
    }

    public HTMLNode copy(boolean deep) {
        try {
            return new HTMLRemarkImpl(text);
        }
        catch (RemarkTextException ex) {
            throw new FeatRuntimeException(ex);
        }
    }

    public StringBuffer toHTML(StringBuffer buf) {
        if ( text != null )
            buf.append("<!--").append(text).append("-->");
        return buf;
    }

    public int getNodeType() {
        return NODETYPE_REMARK;
    }

    public HTMLNode getFirstChild() throws NodeNotFoundException {
        throw new NodeNotFoundException();
    }

    public void setFirstChild(HTMLNode child) {
    }

}

