/*
 * $Revision: 1.1 $ $Date: 2005/09/08 01:32:34 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 * 쐬F 2005/8/22
 */

package feat.v1.impl.template;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import feat.v1.TemplateParsingException;
import feat.v1.config.FileLocator;
import feat.v1.template.HTMLDocument;
import feat.v1.template.HTMLTemplate;

public class HTMLTemplateImpl implements HTMLTemplate {

    private static Log log = LogFactory.getLog(HTMLTemplateImpl.class);

    private HTMLDocument document;
    private FileLocator locator;
    private String encoding;

    /**
     * t@Cev[g[hB
     * @param locator t@C̈ʒu
     * @param encoding R[hBnullw肷HTML画f
     * @throws TemplateParsingException
     */
    HTMLTemplateImpl(FileLocator locator, String encoding, HTMLDocument document) throws TemplateParsingException {
        this.locator = locator;
        this.encoding = encoding;
        this.document = document;
    }

    /**
     * ev[g̃Rs[ԂB
     * ̃\bh̓XbhZ[tB
     * @return feat.html.HTMLTagNode
     */
    synchronized public HTMLDocument getDocument() {
        return (HTMLDocument)document.copy(true);
    }

    public FileLocator getLocation() {
        return locator;
    }

    public String getEncoding() {
        return encoding;
    }

}
