/*
 * $Id: NodeListIterator.java,v 1.2 2005/11/03 13:58:59 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/10/29
 */
package feat.v1.template;

import java.util.NoSuchElementException;

import feat.v1.impl.template.HTMLNodeImpl;

/**
 * m[ȟZm[hǂCe[^B
 * @author SUGIMOTO Ken-ichi
 */
public class NodeListIterator implements NodeIterator {

    private HTMLNode current;
    private HTMLNode next;
    private HTMLNode currentBak;
    private HTMLNode nextBak;

    /**
     *
     * @param start Jn_ƂȂm[hB
     */
    public NodeListIterator(HTMLNode start) {
        nextBak = next = start;
    }

    public void remove() {
        if ( current == null ) {
            throw new IllegalStateException();
        }
        else {
            current.detach();
            current = null;
        }
    }

    public boolean hasNext() {
        return next != null;
    }

    public Object next() {
        if ( next == null )
            throw new NoSuchElementException();

        // current, next̓e1i߂
        current = next;
        next = ((HTMLNodeImpl)next).next;

        return current;
    }

    public HTMLNode nextNode() {
        return (HTMLNode)next();
    }

    public void mark() {
        currentBak = current;
        nextBak = next;
    }

    public void reset() {
        current = currentBak;
        next = nextBak;
    }

    public boolean skip(Object o) {
        HTMLNode c = current;
        HTMLNode n = next;
        while(hasNext()) {
            if ( next() == o )
                return true;
        }
        current = c;
        next = n;
        return false;
    }


}
