/*
 * $Id: InputSupport.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/08
 */
package feat2.config;

import java.util.ArrayList;

import feat2.FeatErrors;

/**
 * Input要素をサポートするためのクラス。
 * @author SUGIMOTO Ken-ichi
 */
public class InputSupport implements DIComponentConfig {

    private ArrayList inputs;
    private Config config;

    public InputSupport(Config config) {
        this.config = config;
        inputs = new ArrayList();
    }

    public void addInput(InputConfigBase input) {
        inputs.add(input);
        input.setParent(config);
    }

    public InputConfigBase[] getInputs() {
        return (InputConfigBase[])inputs.toArray(new InputConfigBase[inputs.size()]);
    }

    public InputConfigBase getInputConfig(String propertyName) {
        InputConfigBase ret = (InputConfigBase)ConfigUtil.getConfig(inputs, propertyName);
        return ret;
    }

    public boolean validate(FeatErrors errs) {
        return ConfigUtil.validate(inputs.iterator(), errs);
    }

}
